/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.duplication;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.cpd.TokenEntry;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.duplication.DuplicationTokenBuilder;
import org.sonar.batch.duplication.BlockCache;
import org.sonar.duplications.block.FileBlocks;
import org.sonar.duplications.internal.pmd.PmdBlockChunker;
import org.sonar.duplications.internal.pmd.TokenizerBridge;

public class DefaultTokenBuilder
implements DuplicationTokenBuilder {
    private final BlockCache cache;
    private final InputFile inputFile;
    private final List<TokenEntry> tokens = new ArrayList<TokenEntry>();
    private final PmdBlockChunker blockChunker;
    private boolean done = false;
    private int previousLine = 0;

    public DefaultTokenBuilder(InputFile inputFile, BlockCache cache, PmdBlockChunker blockChunker) {
        this.inputFile = inputFile;
        this.cache = cache;
        this.blockChunker = blockChunker;
        TokenEntry.clearImages();
    }

    public DefaultTokenBuilder addToken(int line, String image) {
        Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"done() already called");
        Preconditions.checkState((line >= this.previousLine ? 1 : 0) != 0, (Object)("Token should be created in order. Previous line was " + this.previousLine + " and you tried to create a token at line " + line));
        TokenEntry cpdToken = new TokenEntry(image, this.inputFile.absolutePath(), line);
        this.tokens.add(cpdToken);
        this.previousLine = line;
        return this;
    }

    public void done() {
        Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"done() already called");
        this.tokens.add(TokenEntry.getEOF());
        TokenEntry.clearImages();
        List tokensLines = TokenizerBridge.convert(this.tokens);
        List blocks = this.blockChunker.chunk(((DefaultInputFile)this.inputFile).key(), tokensLines);
        this.cache.put(((DefaultInputFile)this.inputFile).key(), new FileBlocks(((DefaultInputFile)this.inputFile).key(), blocks));
        this.tokens.clear();
    }
}

