/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.debt;

import org.sonar.api.BatchComponent;
import org.sonar.api.config.Settings;
import org.sonar.api.measures.Metric;

public class SqaleRatingSettings
implements BatchComponent {
    private final Settings settings;

    public SqaleRatingSettings(Settings settings) {
        this.settings = settings;
    }

    public double[] getRatingGrid() {
        try {
            String[] ratingGrades = this.settings.getStringArray("sonar.technicalDebt.ratingGrid");
            double[] grid = new double[4];
            for (int i = 0; i < 4; ++i) {
                grid[i] = Double.parseDouble(ratingGrades[i]);
            }
            return grid;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The SQALE rating grid is incorrect. Expected something similar to '0.1,0.2,0.5,1' and got '" + this.settings.getString("sonar.technicalDebt.ratingGrid") + "'", e);
        }
    }

    public long getDevCost(String languageKey) {
        try {
            LanguageSpecificConfiguration languageSpecificConfig = this.getSpecificParametersForLanguage(languageKey);
            if (languageSpecificConfig != null && languageSpecificConfig.getManDays() != null) {
                return Long.parseLong(languageSpecificConfig.getManDays());
            }
            return Long.parseLong(this.settings.getString("sonar.technicalDebt.developmentCost"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The value of the SQALE property 'sonar.technicalDebt.developmentCost' is incorrect. Expected long but got '" + this.settings.getString("sonar.technicalDebt.developmentCost") + "'", e);
        }
    }

    public Metric getSizeMetric(String languageKey, Metric[] metrics) {
        LanguageSpecificConfiguration languageSpecificConfig = this.getSpecificParametersForLanguage(languageKey);
        if (languageSpecificConfig != null && languageSpecificConfig.getMetric() != null) {
            return this.getMetricForKey(languageSpecificConfig.getMetric(), metrics);
        }
        return this.getMetricForKey(this.settings.getString("sonar.technicalDebt.sizeMetric"), metrics);
    }

    private Metric getMetricForKey(String sizeMetricKey, Metric[] metrics) {
        for (Metric metric : metrics) {
            if (!metric.getKey().equals(sizeMetricKey)) continue;
            return metric;
        }
        throw new IllegalArgumentException("The metric key used to define the SQALE size metric is unknown : '" + sizeMetricKey + "'");
    }

    private LanguageSpecificConfiguration getSpecificParametersForLanguage(String languageKey) {
        String[] languageConfigIndexes;
        for (String languageConfigIndex : languageConfigIndexes = this.settings.getStringArray("languageSpecificParameters")) {
            String languagePropertyKey = "languageSpecificParameters." + languageConfigIndex + "." + "language";
            if (!languageKey.equals(this.settings.getString(languagePropertyKey))) continue;
            return LanguageSpecificConfiguration.create(this.settings, languageConfigIndex);
        }
        return null;
    }

    private static class LanguageSpecificConfiguration {
        private final String language;
        private final String manDays;
        private final String metric;

        private LanguageSpecificConfiguration(String language, String manDays, String metric) {
            this.language = language;
            this.manDays = manDays;
            this.metric = metric;
        }

        static LanguageSpecificConfiguration create(Settings settings, String configurationId) {
            String configurationPrefix = "languageSpecificParameters." + configurationId + ".";
            String language = settings.getString(configurationPrefix + "language");
            String manDays = settings.getString(configurationPrefix + "man_days");
            String metric = settings.getString(configurationPrefix + "size_metric");
            return new LanguageSpecificConfiguration(language, manDays, metric);
        }

        String getLanguage() {
            return this.language;
        }

        String getManDays() {
            return this.manDays;
        }

        String getMetric() {
            return this.metric;
        }
    }
}

