/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.debt;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import org.sonar.api.utils.MessageException;

class SqaleRatingGrid {
    private final double[] gridValues;

    public SqaleRatingGrid(double[] gridValues) {
        this.gridValues = Arrays.copyOf(gridValues, gridValues.length);
    }

    public int getRatingForDensity(double density) {
        for (SqaleRating sqaleRating : SqaleRating.values()) {
            double lowerBound = this.getGradeLowerBound(sqaleRating);
            if (!(density >= lowerBound)) continue;
            return sqaleRating.getIndex();
        }
        throw MessageException.of((String)("The SQALE density value should be between 0 and 1.7976931348623157E308 and got " + density));
    }

    @VisibleForTesting
    double getGradeLowerBound(SqaleRating rating) {
        if (rating.getIndex() > 1) {
            return this.gridValues[rating.getIndex() - 2];
        }
        return 0.0;
    }

    static enum SqaleRating {
        E(5),
        D(4),
        C(3),
        B(2),
        A(1);

        private final int index;

        private SqaleRating(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static SqaleRating createForIndex(int index) {
            for (SqaleRating rating : SqaleRating.values()) {
                if (rating.getIndex() != index) continue;
                return rating;
            }
            throw new IllegalArgumentException("A SQALE rating must be in the range [1..5].");
        }
    }
}

