/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.debt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.batch.debt.SqaleRatingGrid;
import org.sonar.batch.debt.SqaleRatingSettings;

public final class SqaleRatingDecorator
implements Decorator {
    private final SqaleRatingSettings sqaleRatingSettings;
    private final Metric[] metrics;
    private final FileSystem fs;

    public SqaleRatingDecorator(SqaleRatingSettings sqaleRatingSettings, Metric[] metrics, FileSystem fs) {
        this.sqaleRatingSettings = sqaleRatingSettings;
        this.metrics = Arrays.copyOf(metrics, metrics.length);
        this.fs = fs;
    }

    @VisibleForTesting
    SqaleRatingDecorator() {
        this.sqaleRatingSettings = null;
        this.metrics = null;
        this.fs = null;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    @DependsUpon
    public List<Metric> dependsOnMetrics() {
        return Lists.newArrayList((Object[])new Metric[]{CoreMetrics.TECHNICAL_DEBT, CoreMetrics.NCLOC, CoreMetrics.COMPLEXITY});
    }

    @DependedUpon
    public List<Metric> generatesMetrics() {
        return Lists.newArrayList((Object[])new Metric[]{CoreMetrics.SQALE_RATING, CoreMetrics.DEVELOPMENT_COST, CoreMetrics.SQALE_DEBT_RATIO});
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (ResourceUtils.isPersistable((Resource)resource) && !ResourceUtils.isUnitTestClass((Resource)resource)) {
            Long developmentCost = this.getDevelopmentCost(context);
            context.saveMeasure(new Measure(CoreMetrics.DEVELOPMENT_COST, Long.toString(developmentCost)));
            long debt = this.getMeasureValue(context, CoreMetrics.TECHNICAL_DEBT);
            double density = this.computeDensity(debt, developmentCost.longValue());
            context.saveMeasure(CoreMetrics.SQALE_DEBT_RATIO, Double.valueOf(100.0 * density));
            SqaleRatingGrid ratingGrid = new SqaleRatingGrid(this.sqaleRatingSettings.getRatingGrid());
            context.saveMeasure(this.createRatingMeasure(ratingGrid.getRatingForDensity(density)));
        }
    }

    private Measure createRatingMeasure(int rating) {
        return new Measure(CoreMetrics.SQALE_RATING).setIntValue(Integer.valueOf(rating)).setData(SqaleRatingDecorator.toRatingLetter(rating));
    }

    static String toRatingLetter(@Nullable Integer rating) {
        if (rating != null) {
            return SqaleRatingGrid.SqaleRating.createForIndex(rating).name();
        }
        return null;
    }

    private long getDevelopmentCost(DecoratorContext context) {
        InputFile file = this.fs.inputFile(this.fs.predicates().hasRelativePath(context.getResource().getKey()));
        if (file != null) {
            String language = file.language();
            return this.getMeasureValue(context, this.sqaleRatingSettings.getSizeMetric(language, this.metrics)) * this.sqaleRatingSettings.getDevCost(language);
        }
        Collection childrenMeasures = context.getChildrenMeasures(CoreMetrics.DEVELOPMENT_COST);
        Double sum = SqaleRatingDecorator.sum(childrenMeasures);
        return sum.longValue();
    }

    private static Double sum(@Nullable Collection<Measure> measures) {
        if (measures == null) {
            return 0.0;
        }
        double sum = 0.0;
        for (Measure measure : measures) {
            String data = measure.getData();
            if (data == null) continue;
            sum += Double.parseDouble(data);
        }
        return sum;
    }

    private long getMeasureValue(DecoratorContext context, Metric metric) {
        Measure measure = context.getMeasure(metric);
        if (measure != null) {
            return measure.getValue().longValue();
        }
        return 0L;
    }

    protected double computeDensity(double debt, double developmentCost) {
        if (developmentCost != 0.0) {
            return debt / developmentCost;
        }
        return 0.0;
    }
}

