/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.utils.TempFolder;
import org.sonar.api.utils.internal.DefaultTempFolder;
import org.sonar.batch.bootstrap.BootstrapProperties;

public class TempFolderProvider
extends ProviderAdapter {
    private TempFolder tempFolder;

    public TempFolder provide(BootstrapProperties bootstrapProps) {
        if (this.tempFolder == null) {
            String workingDirPath = StringUtils.defaultIfBlank((String)bootstrapProps.property("sonar.working.directory"), (String)".sonar");
            File workingDir = new File(workingDirPath).getAbsoluteFile();
            File tempDir = new File(workingDir, ".sonartmp");
            try {
                FileUtils.forceMkdir((File)tempDir);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create root temp directory " + tempDir, e);
            }
            this.tempFolder = new DefaultTempFolder(tempDir);
        }
        return this.tempFolder;
    }
}

