/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.batch.bootstrap.BootstrapProperties;
import org.sonar.batch.bootstrapper.EnvironmentInformation;

public class ServerClient
implements BatchComponent {
    private BootstrapProperties props;
    private HttpDownloader.BaseHttpDownloader downloader;

    public ServerClient(BootstrapProperties settings, EnvironmentInformation env) {
        this.props = settings;
        this.downloader = new HttpDownloader.BaseHttpDownloader(settings.properties(), env.toString());
    }

    public String getURL() {
        return StringUtils.removeEnd((String)StringUtils.defaultIfBlank((String)this.props.property("sonar.host.url"), (String)"http://localhost:9000"), (String)"/");
    }

    public void download(String pathStartingWithSlash, File toFile) {
        this.download(pathStartingWithSlash, toFile, null);
    }

    public void download(String pathStartingWithSlash, File toFile, @Nullable Integer readTimeoutMillis) {
        try {
            InputSupplier<InputStream> inputSupplier = this.doRequest(pathStartingWithSlash, readTimeoutMillis);
            Files.copy(inputSupplier, (File)toFile);
        }
        catch (HttpDownloader.HttpException he) {
            throw this.handleHttpException(he);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to download '%s' to: %s", pathStartingWithSlash, toFile), e);
        }
    }

    public String request(String pathStartingWithSlash) {
        return this.request(pathStartingWithSlash, true);
    }

    public String request(String pathStartingWithSlash, boolean wrapHttpException) {
        return this.request(pathStartingWithSlash, wrapHttpException, null);
    }

    public String request(String pathStartingWithSlash, boolean wrapHttpException, @Nullable Integer timeoutMillis) {
        InputSupplier<InputStream> inputSupplier = this.doRequest(pathStartingWithSlash, timeoutMillis);
        try {
            return IOUtils.toString((InputStream)((InputStream)inputSupplier.getInput()), (String)"UTF-8");
        }
        catch (HttpDownloader.HttpException e) {
            throw wrapHttpException ? this.handleHttpException(e) : e;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to request: %s", pathStartingWithSlash), e);
        }
    }

    private InputSupplier<InputStream> doRequest(String pathStartingWithSlash, @Nullable Integer timeoutMillis) {
        Preconditions.checkArgument((boolean)pathStartingWithSlash.startsWith("/"), (Object)"Path must start with slash /");
        String path = StringEscapeUtils.escapeHtml((String)pathStartingWithSlash);
        URI uri = URI.create(this.getURL() + path);
        try {
            InputSupplier inputSupplier = Strings.isNullOrEmpty((String)this.getLogin()) ? this.downloader.newInputSupplier(uri, timeoutMillis) : this.downloader.newInputSupplier(uri, this.getLogin(), this.getPassword(), timeoutMillis);
            return inputSupplier;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to request: %s", uri), e);
        }
    }

    private RuntimeException handleHttpException(HttpDownloader.HttpException he) {
        if (he.getResponseCode() == 401) {
            return new IllegalStateException(String.format(this.getMessageWhenNotAuthorized(), "sonar.login", "sonar.password"));
        }
        if (he.getResponseCode() == 403) {
            return new IllegalStateException(he.getResponseContent());
        }
        return new IllegalStateException(String.format("Fail to execute request [code=%s, url=%s]", he.getResponseCode(), he.getUri()), he);
    }

    private String getMessageWhenNotAuthorized() {
        if (Strings.isNullOrEmpty((String)this.getLogin()) && Strings.isNullOrEmpty((String)this.getPassword())) {
            return "Not authorized. Analyzing this project requires to be authenticated. Please provide the values of the properties %s and %s.";
        }
        return "Not authorized. Please check the properties %s and %s.";
    }

    private String getLogin() {
        return this.props.property("sonar.login");
    }

    private String getPassword() {
        return this.props.property("sonar.password");
    }

    public static String encodeForUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Encoding not supported", e);
        }
    }
}

