/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JdbcLeakPrevention {
    public List<String> unregisterDrivers() throws SQLException {
        Set<Driver> registeredDrivers = this.registeredDrivers();
        ArrayList<String> unregisteredNames = new ArrayList<String>();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (driver.getClass().getClassLoader() != this.getClass().getClassLoader()) continue;
            if (registeredDrivers.contains(driver)) {
                unregisteredNames.add(driver.getClass().getCanonicalName());
            }
            DriverManager.deregisterDriver(driver);
        }
        return unregisteredNames;
    }

    private Set<Driver> registeredDrivers() {
        HashSet<Driver> registeredDrivers = new HashSet<Driver>();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            registeredDrivers.add(driver);
        }
        return registeredDrivers;
    }
}

