/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.BootstrapProperties;
import org.sonar.batch.protocol.input.GlobalReferentials;

public class GlobalSettings
extends Settings {
    private Configuration deprecatedConfiguration;
    private final BootstrapProperties bootstrapProps;
    private final GlobalReferentials globalReferentials;
    private final AnalysisMode mode;

    public GlobalSettings(BootstrapProperties bootstrapProps, PropertyDefinitions propertyDefinitions, GlobalReferentials globalReferentials, Configuration deprecatedConfiguration, AnalysisMode mode) {
        super(propertyDefinitions);
        this.mode = mode;
        this.getEncryption().setPathToSecretKey(bootstrapProps.property("sonar.secretKeyPath"));
        this.bootstrapProps = bootstrapProps;
        this.globalReferentials = globalReferentials;
        this.deprecatedConfiguration = deprecatedConfiguration;
        this.init();
    }

    private void init() {
        this.addProperties(this.globalReferentials.globalSettings());
        this.addProperties(this.bootstrapProps.properties());
    }

    protected void doOnSetProperty(String key, @Nullable String value) {
        this.deprecatedConfiguration.setProperty(key, (Object)value);
    }

    protected void doOnRemoveProperty(String key) {
        this.deprecatedConfiguration.clearProperty(key);
    }

    protected void doOnClearProperties() {
        this.deprecatedConfiguration.clear();
    }

    protected void doOnGetProperties(String key) {
        if (this.mode.isPreview() && key.endsWith(".secured") && !key.contains(".license")) {
            throw MessageException.of((String)("Access to the secured property '" + key + "' is not possible in preview mode. The SonarQube plugin which requires this property must be deactivated in preview mode."));
        }
    }
}

