/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarPlugin;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.batch.bootstrap.PluginsReferential;
import org.sonar.batch.bootstrap.ServerClient;
import org.sonar.core.plugins.RemotePlugin;
import org.sonar.core.plugins.RemotePluginFile;
import org.sonar.home.cache.FileCache;

public class DefaultPluginsReferential
implements PluginsReferential {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPluginsReferential.class);
    private ServerClient server;
    private FileCache fileCache;

    public DefaultPluginsReferential(FileCache fileCache, ServerClient server) {
        this.server = server;
        this.fileCache = fileCache;
    }

    @Override
    public File pluginFile(final RemotePlugin remote) {
        try {
            final RemotePluginFile file = remote.file();
            return this.fileCache.get(file.getFilename(), file.getHash(), new FileCache.Downloader(){

                public void download(String filename, File toFile) throws IOException {
                    String url = "/deploy/plugins/" + remote.getKey() + "/" + file.getFilename();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Download {} to {}", (Object)url, (Object)toFile.getAbsolutePath());
                    } else {
                        LOG.info("Download {}", (Object)file.getFilename());
                    }
                    DefaultPluginsReferential.this.server.download(url, toFile);
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to download plugin: " + remote.getKey(), e);
        }
    }

    @Override
    public List<RemotePlugin> pluginList() {
        String url = "/deploy/plugins/index.txt";
        try {
            LOG.debug("Download index of plugins");
            String indexContent = this.server.request(url);
            String[] rows = StringUtils.split((String)indexContent, (char)'\n');
            ArrayList remoteLocations = Lists.newArrayList();
            for (String row : rows) {
                remoteLocations.add(RemotePlugin.unmarshal((String)row));
            }
            return remoteLocations;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to download plugins index: " + url, e);
        }
    }

    @Override
    public Map<PluginMetadata, SonarPlugin> localPlugins() {
        return Collections.emptyMap();
    }
}

