/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugin;
import org.sonar.api.SonarPlugin;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.api.platform.PluginRepository;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.BatchPluginJarInstaller;
import org.sonar.batch.bootstrap.PluginsReferential;
import org.sonar.core.plugins.DefaultPluginMetadata;
import org.sonar.core.plugins.PluginClassloaders;
import org.sonar.core.plugins.RemotePlugin;

public class BatchPluginRepository
implements PluginRepository {
    private static final Logger LOG = LoggerFactory.getLogger(BatchPluginRepository.class);
    private static final String CORE_PLUGIN = "core";
    private PluginsReferential pluginsReferential;
    private Map<String, Plugin> pluginsByKey;
    private Map<String, PluginMetadata> metadataByKey;
    private Settings settings;
    private PluginClassloaders classLoaders;
    private final AnalysisMode analysisMode;
    private final BatchPluginJarInstaller pluginInstaller;

    public BatchPluginRepository(PluginsReferential pluginsReferential, Settings settings, AnalysisMode analysisMode, BatchPluginJarInstaller pluginInstaller) {
        this.pluginsReferential = pluginsReferential;
        this.settings = settings;
        this.analysisMode = analysisMode;
        this.pluginInstaller = pluginInstaller;
    }

    public void start() {
        LOG.info("Install plugins");
        this.doStart(this.pluginsReferential.pluginList());
        Map<PluginMetadata, SonarPlugin> localPlugins = this.pluginsReferential.localPlugins();
        if (!localPlugins.isEmpty()) {
            LOG.info("Install local plugins");
            for (Map.Entry<PluginMetadata, SonarPlugin> pluginByMetadata : localPlugins.entrySet()) {
                this.metadataByKey.put(pluginByMetadata.getKey().getKey(), pluginByMetadata.getKey());
                this.pluginsByKey.put(pluginByMetadata.getKey().getKey(), (Plugin)pluginByMetadata.getValue());
            }
        }
    }

    void doStart(List<RemotePlugin> remotePlugins) {
        PluginFilter filter = new PluginFilter(this.settings, this.analysisMode);
        this.metadataByKey = Maps.newHashMap();
        for (RemotePlugin remote : remotePlugins) {
            if (!filter.accepts(remote.getKey())) continue;
            File pluginFile = this.pluginsReferential.pluginFile(remote);
            DefaultPluginMetadata metadata = this.pluginInstaller.installToCache(pluginFile, remote.isCore());
            if (StringUtils.isBlank((String)metadata.getBasePlugin()) || filter.accepts(metadata.getBasePlugin())) {
                this.metadataByKey.put(metadata.getKey(), (PluginMetadata)metadata);
                continue;
            }
            LOG.debug("Excluded plugin: " + metadata.getKey());
        }
        this.classLoaders = new PluginClassloaders(Thread.currentThread().getContextClassLoader());
        this.pluginsByKey = this.classLoaders.init(this.metadataByKey.values());
    }

    public void stop() {
        if (this.classLoaders != null) {
            this.classLoaders.clean();
            this.classLoaders = null;
        }
    }

    public Plugin getPlugin(String key) {
        return this.pluginsByKey.get(key);
    }

    public Collection<PluginMetadata> getMetadata() {
        return this.metadataByKey.values();
    }

    public PluginMetadata getMetadata(String pluginKey) {
        return this.metadataByKey.get(pluginKey);
    }

    public Map<PluginMetadata, Plugin> getPluginsByMetadata() {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, PluginMetadata> entry : this.metadataByKey.entrySet()) {
            String pluginKey = entry.getKey();
            PluginMetadata metadata = entry.getValue();
            result.put(metadata, this.pluginsByKey.get(pluginKey));
        }
        return result;
    }

    static class PluginFilter {
        private static final String PROPERTY_IS_DEPRECATED_MSG = "Property {0} is deprecated. Please use {1} instead.";
        Set<String> whites = Sets.newHashSet();
        Set<String> blacks = Sets.newHashSet();

        PluginFilter(Settings settings, AnalysisMode mode) {
            if (settings.hasKey("sonar.includePlugins")) {
                this.whites.addAll(Arrays.asList(settings.getStringArray("sonar.includePlugins")));
            }
            if (settings.hasKey("sonar.excludePlugins")) {
                this.blacks.addAll(Arrays.asList(settings.getStringArray("sonar.excludePlugins")));
            }
            if (mode.isPreview()) {
                if (settings.hasKey("sonar.dryRun.includePlugins")) {
                    LOG.warn(MessageFormat.format(PROPERTY_IS_DEPRECATED_MSG, "sonar.dryRun.includePlugins", "sonar.preview.includePlugins"));
                    this.whites.addAll(PluginFilter.propertyValues(settings, "sonar.dryRun.includePlugins", ""));
                } else {
                    this.whites.addAll(PluginFilter.propertyValues(settings, "sonar.preview.includePlugins", ""));
                }
                if (settings.hasKey("sonar.dryRun.excludePlugins")) {
                    LOG.warn(MessageFormat.format(PROPERTY_IS_DEPRECATED_MSG, "sonar.dryRun.excludePlugins", "sonar.preview.excludePlugins"));
                    this.blacks.addAll(PluginFilter.propertyValues(settings, "sonar.dryRun.excludePlugins", "buildstability,devcockpit,pdfreport,report,scmactivity,views,jira,buildbreaker"));
                } else {
                    this.blacks.addAll(PluginFilter.propertyValues(settings, "sonar.preview.excludePlugins", "buildstability,devcockpit,pdfreport,report,scmactivity,views,jira,buildbreaker"));
                }
            }
            if (!this.whites.isEmpty()) {
                LOG.info("Include plugins: " + Joiner.on((String)", ").join(this.whites));
            }
            if (!this.blacks.isEmpty()) {
                LOG.info("Exclude plugins: " + Joiner.on((String)", ").join(this.blacks));
            }
        }

        static List<String> propertyValues(Settings settings, String key, String defaultValue) {
            String s = StringUtils.defaultIfEmpty((String)settings.getString(key), (String)defaultValue);
            return Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)s));
        }

        boolean accepts(String pluginKey) {
            if (BatchPluginRepository.CORE_PLUGIN.equals(pluginKey)) {
                return true;
            }
            ArrayList mergeList = Lists.newArrayList(this.blacks);
            mergeList.removeAll(this.whites);
            return mergeList.isEmpty() || !mergeList.contains(pluginKey);
        }
    }
}

