/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Event;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.SonarIndex;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.design.Dependency;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.File;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectLink;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Violation;
import org.sonar.api.utils.SonarException;
import org.sonar.core.measure.MeasurementFilters;

public class DefaultSensorContext
implements SensorContext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSensorContext.class);
    private SonarIndex index;
    private Project project;
    private MeasurementFilters filters;

    public DefaultSensorContext(SonarIndex index, Project project, MeasurementFilters filters) {
        this.index = index;
        this.project = project;
        this.filters = filters;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean index(Resource resource) {
        if (this.indexedByCore(resource)) {
            this.logWarning();
            return true;
        }
        return this.index.index(resource);
    }

    private boolean indexedByCore(Resource resource) {
        return StringUtils.equals((String)"DIR", (String)resource.getQualifier()) || StringUtils.equals((String)"FIL", (String)resource.getQualifier());
    }

    public boolean index(Resource resource, Resource parentReference) {
        if (this.indexedByCore(resource)) {
            this.logWarning();
            return true;
        }
        return this.index.index(resource, parentReference);
    }

    private void logWarning() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Plugins are no more responsible for indexing physical resources like directories and files. This is now handled by the platform.", (Throwable)new SonarException("Plugin should not index physical resources"));
        }
    }

    public boolean isExcluded(Resource reference) {
        return this.index.isExcluded(reference);
    }

    public boolean isIndexed(Resource reference, boolean acceptExcluded) {
        return this.index.isIndexed(reference, acceptExcluded);
    }

    public Resource getParent(Resource reference) {
        return this.index.getParent(reference);
    }

    public Collection<Resource> getChildren(Resource reference) {
        return this.index.getChildren(reference);
    }

    public <G extends Serializable> Measure<G> getMeasure(Metric<G> metric) {
        return this.index.getMeasure((Resource)this.project, metric);
    }

    public <M> M getMeasures(MeasuresFilter<M> filter) {
        return (M)this.index.getMeasures((Resource)this.project, filter);
    }

    public Measure saveMeasure(Measure measure) {
        return this.index.addMeasure((Resource)this.project, measure);
    }

    public Measure saveMeasure(Metric metric, Double value) {
        return this.index.addMeasure((Resource)this.project, new Measure(metric, value));
    }

    public <G extends Serializable> Measure<G> getMeasure(Resource resource, Metric<G> metric) {
        return this.index.getMeasure(resource, metric);
    }

    public String saveResource(Resource resource) {
        Resource persistedResource = this.index.addResource(resource);
        if (persistedResource != null) {
            return persistedResource.getEffectiveKey();
        }
        return null;
    }

    public boolean saveResource(Resource resource, Resource parentReference) {
        return this.index.index(resource, parentReference);
    }

    public Resource getResource(Resource resource) {
        return this.index.getResource(resource);
    }

    public <M> M getMeasures(Resource resource, MeasuresFilter<M> filter) {
        return (M)this.index.getMeasures(resource, filter);
    }

    public Measure saveMeasure(Resource resource, Metric metric, Double value) {
        return this.saveMeasure(resource, new Measure(metric, value));
    }

    public Measure saveMeasure(Resource resource, Measure measure) {
        if (this.filters.accept(resource, measure)) {
            return this.index.addMeasure(this.resourceOrProject(resource), measure);
        }
        return measure;
    }

    public void saveViolation(Violation violation, boolean force) {
        if (violation.getResource() == null) {
            violation.setResource(this.resourceOrProject(violation.getResource()));
        }
        this.index.addViolation(violation, force);
    }

    public void saveViolation(Violation violation) {
        this.saveViolation(violation, false);
    }

    public void saveViolations(Collection<Violation> violations) {
        if (violations != null) {
            for (Violation violation : violations) {
                this.saveViolation(violation);
            }
        }
    }

    public Dependency saveDependency(Dependency dependency) {
        return this.index.addDependency(dependency);
    }

    public Set<Dependency> getDependencies() {
        return this.index.getDependencies();
    }

    public Collection<Dependency> getIncomingDependencies(Resource to) {
        return this.index.getIncomingEdges((Object)this.resourceOrProject(to));
    }

    public Collection<Dependency> getOutgoingDependencies(Resource from) {
        return this.index.getOutgoingEdges((Object)this.resourceOrProject(from));
    }

    public void saveSource(Resource reference, String source) {
    }

    public void saveLink(ProjectLink link) {
        this.index.addLink(link);
    }

    public void deleteLink(String key) {
        this.index.deleteLink(key);
    }

    public List<Event> getEvents(Resource resource) {
        return this.index.getEvents(resource);
    }

    public Event createEvent(Resource resource, String name, String description, String category, Date date) {
        return this.index.addEvent(resource, name, description, category, date);
    }

    public void deleteEvent(Event event) {
        this.index.deleteEvent(event);
    }

    private Resource resourceOrProject(Resource resource) {
        if (resource == null) {
            return this.project;
        }
        Resource indexedResource = this.getResource(resource);
        return indexedResource != null ? indexedResource : resource;
    }

    public Measure saveMeasure(InputFile inputFile, Metric metric, Double value) {
        return this.saveMeasure(this.getResource((InputPath)inputFile), metric, value);
    }

    public Measure saveMeasure(InputFile inputFile, Measure measure) {
        return this.saveMeasure(this.getResource((InputPath)inputFile), measure);
    }

    public Resource getResource(InputPath inputPath) {
        Directory r;
        if (inputPath instanceof InputDir) {
            r = Directory.create((String)((InputDir)inputPath).relativePath());
        } else if (inputPath instanceof InputFile) {
            r = File.create((String)((InputFile)inputPath).relativePath());
        } else {
            throw new IllegalArgumentException("Unknow input path type: " + inputPath);
        }
        return this.getResource((Resource)r);
    }
}

