/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.ExtensionProvider;
import org.sonar.api.Plugin;
import org.sonar.api.batch.CoverageExtension;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.bootstrap.DryRun;
import org.sonar.batch.bootstrap.ExtensionUtils;
import org.sonar.batch.bootstrap.Module;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.batch.config.ProjectSettings;

public final class ProjectExtensionInstaller
implements BatchComponent {
    private BatchPluginRepository pluginRepository;
    private EnvironmentInformation environment;
    private DryRun dryRun;
    private Project project;
    private ProjectSettings settings;

    public ProjectExtensionInstaller(BatchPluginRepository pluginRepository, EnvironmentInformation environment, DryRun dryRun, Project project, ProjectSettings settings) {
        this.pluginRepository = pluginRepository;
        this.environment = environment;
        this.dryRun = dryRun;
        this.project = project;
        this.settings = settings;
    }

    public void install(Module module) {
        for (Map.Entry<String, Plugin> entry : this.pluginRepository.getPluginsByKey().entrySet()) {
            for (Object extension : entry.getValue().getExtensions()) {
                this.installExtension(module, extension, entry.getKey());
            }
        }
        this.installExtensionProviders(module);
    }

    void installExtensionProviders(Module module) {
        List<ExtensionProvider> providers = module.getComponents(ExtensionProvider.class);
        for (ExtensionProvider provider : providers) {
            Object obj = provider.provide();
            if (obj instanceof Iterable) {
                for (Object extension : (Iterable)obj) {
                    this.installExtension(module, extension, "");
                }
                continue;
            }
            this.installExtension(module, obj, "");
        }
    }

    private Object installExtension(Module module, Object extension, String pluginKey) {
        if (ExtensionUtils.isBatchExtension(extension) && ExtensionUtils.isSupportedEnvironment(extension, this.environment) && ExtensionUtils.isInstantiationStrategy(extension, "PER_PROJECT") && ExtensionUtils.checkDryRun(extension, this.dryRun.isEnabled()) && !ProjectExtensionInstaller.isDeactivatedCoverageExtension(extension, pluginKey, this.project, this.settings) && !ProjectExtensionInstaller.isMavenExtensionOnEmulatedMavenProject(extension, this.project)) {
            module.addCoreSingleton(extension);
            return extension;
        }
        return null;
    }

    static boolean isMavenExtensionOnEmulatedMavenProject(Object extension, Project project) {
        return ExtensionUtils.isMavenExtensionOnly(extension) && project.getPom() == null;
    }

    static boolean isDeactivatedCoverageExtension(Object extension, String pluginKey, Project project, Settings settings) {
        if (!ExtensionUtils.isType(extension, CoverageExtension.class)) {
            return false;
        }
        if (!project.getAnalysisType().isDynamic(true)) {
            return true;
        }
        if (StringUtils.equals((String)project.getLanguageKey(), (String)"java")) {
            Object[] selectedPluginKeys = settings.getStringArray("sonar.core.codeCoveragePlugin");
            if (ArrayUtils.isEmpty((Object[])selectedPluginKeys)) {
                selectedPluginKeys = new String[]{"cobertura"};
            }
            return !ArrayUtils.contains((Object[])selectedPluginKeys, (Object)pluginKey);
        }
        return false;
    }
}

