/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.runner.api.Utils;

class Command {
    private final String executable;
    private final List<String> arguments;
    private final Map<String, String> env;
    private final File directory;

    private Command(Builder builder) {
        this.executable = builder.executable;
        this.arguments = Collections.unmodifiableList(builder.arguments);
        this.env = Collections.unmodifiableMap(builder.env);
        this.directory = builder.directory;
    }

    File directory() {
        return this.directory;
    }

    String executable() {
        return this.executable;
    }

    List<String> arguments() {
        return this.arguments;
    }

    Map<String, String> envVariables() {
        return this.env;
    }

    String[] toStrings() {
        String[] strings = new String[1 + this.arguments.size()];
        strings[0] = this.executable;
        for (int index = 0; index < this.arguments.size(); ++index) {
            strings[index + 1] = this.arguments.get(index);
        }
        return strings;
    }

    public String toString() {
        return Utils.join(this.toStrings(), " ");
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private String executable;
        private final List<String> arguments = new ArrayList<String>();
        private final Map<String, String> env = new HashMap<String, String>();
        private File directory;

        private Builder() {
        }

        Builder setExecutable(String s) {
            this.executable = s;
            return this;
        }

        Builder addArguments(String ... args) {
            return this.addArguments(Arrays.asList(args));
        }

        Builder addArguments(List<String> args) {
            for (String arg : args) {
                if (arg == null || "".equals(arg.trim())) continue;
                this.arguments.add(arg);
            }
            return this;
        }

        Builder setEnvVariable(String key, String value) {
            this.env.put(key, value);
            return this;
        }

        Builder addEnvVariables(Map<String, String> map) {
            this.env.putAll(map);
            return this;
        }

        Builder setDirectory(File d) {
            this.directory = d;
            return this;
        }

        Command build() {
            if (this.executable == null) {
                throw new IllegalArgumentException("Command executable is not defined");
            }
            return new Command(this);
        }
    }
}

