/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner;

import org.sonar.runner.api.RunnerVersion;

class SystemInfo {
    private SystemInfo() {
    }

    static void print() {
        System.out.println("SonarQube Runner " + RunnerVersion.version());
        System.out.println(SystemInfo.java());
        System.out.println(SystemInfo.os());
        String runnerOpts = System.getenv("SONAR_RUNNER_OPTS");
        if (runnerOpts != null) {
            System.out.println("SONAR_RUNNER_OPTS=" + runnerOpts);
        }
    }

    static String java() {
        StringBuilder sb = new StringBuilder();
        sb.append("Java ").append(System.getProperty("java.version")).append(" ").append(System.getProperty("java.vendor"));
        String bits = System.getProperty("sun.arch.data.model");
        if ("32".equals(bits) || "64".equals(bits)) {
            sb.append(" (").append(bits).append("-bit)");
        }
        return sb.toString();
    }

    static String os() {
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append(" ").append(System.getProperty("os.arch"));
        return sb.toString();
    }
}

