/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.sonar.runner.impl.Logs;
import org.sonar.runner.kevinsawicki.HttpRequest;

class ServerConnection {
    static final int CONNECT_TIMEOUT_MILLISECONDS = 30000;
    static final int READ_TIMEOUT_MILLISECONDS = 60000;
    private static final Pattern CHARSET_PATTERN = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");
    private final String serverUrl;
    private final String userAgent;

    private ServerConnection(String serverUrl, String app, String appVersion) {
        this.serverUrl = this.removeEndSlash(serverUrl);
        this.userAgent = app + "/" + appVersion;
    }

    private String removeEndSlash(String url) {
        if (url == null) {
            return null;
        }
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    static ServerConnection create(Properties properties) {
        String serverUrl = properties.getProperty("sonar.host.url");
        String app = properties.getProperty("sonarRunner.app");
        String appVersion = properties.getProperty("sonarRunner.appVersion");
        return new ServerConnection(serverUrl, app, appVersion);
    }

    void download(String path, File toFile) {
        String fullUrl = this.serverUrl + path;
        try {
            Logs.debug("Download " + fullUrl + " to " + toFile.getAbsolutePath());
            HttpRequest httpRequest = this.newHttpRequest(new URL(fullUrl));
            if (!httpRequest.ok()) {
                throw new IOException("Status returned by url : '" + fullUrl + "' is invalid : " + httpRequest.code());
            }
            httpRequest.receive(toFile);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException || e.getCause() instanceof UnknownHostException) {
                Logs.error("Sonar server '" + this.serverUrl + "' can not be reached");
            }
            FileUtils.deleteQuietly(toFile);
            throw new IllegalStateException("Fail to download: " + fullUrl, e);
        }
    }

    String downloadString(String path) throws IOException {
        String fullUrl = this.serverUrl + path;
        HttpRequest httpRequest = this.newHttpRequest(new URL(fullUrl));
        try {
            String charset = ServerConnection.getCharsetFromContentType(httpRequest.contentType());
            if (charset == null || "".equals(charset)) {
                charset = "UTF-8";
            }
            if (!httpRequest.ok()) {
                throw new IOException("Status returned by url : '" + fullUrl + "' is invalid : " + httpRequest.code());
            }
            String string = httpRequest.body(charset);
            return string;
        }
        catch (HttpRequest.HttpRequestException e) {
            if (e.getCause() instanceof ConnectException || e.getCause() instanceof UnknownHostException) {
                Logs.error("Sonar server '" + this.serverUrl + "' can not be reached");
            }
            throw e;
        }
        finally {
            httpRequest.disconnect();
        }
    }

    private HttpRequest newHttpRequest(URL url) {
        HttpRequest request = HttpRequest.get(url);
        request.trustAllCerts().trustAllHosts();
        request.acceptGzipEncoding().uncompress(true);
        request.connectTimeout(30000).readTimeout(60000);
        request.userAgent(this.userAgent);
        return request;
    }

    static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = CHARSET_PATTERN.matcher(contentType);
        if (m.find()) {
            return m.group(1).trim().toUpperCase();
        }
        return null;
    }
}

