/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.sonar.runner.impl.JarExtractor;
import org.sonar.runner.impl.ServerConnection;

class Jars30 {
    private static final String BATCH_PATH = "/batch/";
    private final ServerConnection connection;

    Jars30(ServerConnection conn) {
        this.connection = conn;
    }

    List<File> download(File workDir, JarExtractor jarExtractor) {
        ArrayList<File> files = new ArrayList<File>();
        files.add(jarExtractor.extractToTemp("sonar-runner-batch"));
        files.addAll(this.downloadFiles(workDir));
        return files;
    }

    private List<File> downloadFiles(File workDir) {
        try {
            ArrayList<File> files = new ArrayList<File>();
            String libs = this.connection.downloadString(BATCH_PATH);
            File dir = new File(workDir, "batch");
            dir.mkdirs();
            for (String lib : libs.split(",")) {
                File file = new File(dir, lib);
                this.connection.download(BATCH_PATH + lib, file);
                files.add(file);
            }
            return files;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to download libraries from server", e);
        }
    }
}

