/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.api;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.sonar.runner.api.Runner;
import org.sonar.runner.api.Utils;
import org.sonar.runner.impl.Logs;

class Dirs {
    Dirs() {
    }

    void init(Runner runner) {
        boolean onProject = Utils.taskRequiresProject(runner.properties());
        if (onProject) {
            this.initProjectDirs(runner);
        } else {
            this.initTaskDirs(runner);
        }
    }

    private void initProjectDirs(Runner runner) {
        File workDir;
        String path = runner.property("sonar.projectBaseDir", ".");
        File projectDir = new File(path);
        if (!projectDir.isDirectory()) {
            throw new IllegalStateException("Project home must be an existing directory: " + path);
        }
        runner.setProperty("sonar.projectBaseDir", projectDir.getAbsolutePath());
        path = runner.property("sonar.working.directory", "");
        if ("".equals(path.trim())) {
            workDir = new File(projectDir, ".sonar");
        } else {
            workDir = new File(path);
            if (!workDir.isAbsolute()) {
                workDir = new File(projectDir, path);
            }
        }
        FileUtils.deleteQuietly(workDir);
        runner.setProperty("sonar.working.directory", workDir.getAbsolutePath());
        Logs.info("Work directory: " + workDir.getAbsolutePath());
    }

    private void initTaskDirs(Runner runner) {
        String path = runner.property("sonar.working.directory", ".");
        File workDir = new File(path);
        runner.setProperty("sonar.working.directory", workDir.getAbsolutePath());
    }
}

