/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.sonar.runner.api.Command;
import org.sonar.runner.api.CommandException;
import org.sonar.runner.api.ProcessMonitor;
import org.sonar.runner.api.StreamConsumer;

class CommandExecutor {
    private static final CommandExecutor INSTANCE = new CommandExecutor();

    private CommandExecutor() {
    }

    static CommandExecutor create() {
        return INSTANCE;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int execute(Command command, StreamConsumer stdOut, StreamConsumer stdErr, long timeoutMilliseconds, @Nullable ProcessMonitor processMonitor) {
        int n;
        ExecutorService executorService = null;
        Process process = null;
        StreamGobbler outputGobbler = null;
        StreamGobbler errorGobbler = null;
        try {
            ProcessBuilder builder = new ProcessBuilder(command.toStrings());
            builder.directory(command.directory());
            builder.environment().putAll(command.envVariables());
            process = builder.start();
            outputGobbler = new StreamGobbler(process.getInputStream(), stdOut);
            errorGobbler = new StreamGobbler(process.getErrorStream(), stdErr);
            outputGobbler.start();
            errorGobbler.start();
            executorService = Executors.newSingleThreadExecutor();
            Future<Integer> futureTask = this.executeProcess(executorService, process);
            if (processMonitor != null) {
                this.monitorProcess(processMonitor, executorService, process);
            }
            int exitCode = futureTask.get(timeoutMilliseconds, TimeUnit.MILLISECONDS);
            this.waitUntilFinish(outputGobbler);
            this.waitUntilFinish(errorGobbler);
            this.verifyGobbler(command, outputGobbler, "stdOut");
            this.verifyGobbler(command, errorGobbler, "stdErr");
            n = exitCode;
        }
        catch (TimeoutException te) {
            try {
                process.destroy();
                throw new CommandException("Timeout exceeded: " + timeoutMilliseconds + " ms", command, te);
                catch (CommandException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CommandException("Fail to execute command", command, e);
                }
            }
            catch (Throwable throwable) {
                this.waitUntilFinish(outputGobbler);
                this.waitUntilFinish(errorGobbler);
                this.closeStreams(process);
                if (executorService != null) {
                    executorService.shutdown();
                }
                throw throwable;
            }
        }
        this.waitUntilFinish(outputGobbler);
        this.waitUntilFinish(errorGobbler);
        this.closeStreams(process);
        if (executorService != null) {
            executorService.shutdown();
        }
        return n;
    }

    private void monitorProcess(final ProcessMonitor processMonitor, final ExecutorService executor, final Process process) {
        new Thread(){

            @Override
            public void run() {
                while (!executor.isTerminated()) {
                    if (processMonitor.stop()) {
                        process.destroy();
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }.start();
    }

    private Future<Integer> executeProcess(ExecutorService executorService, Process process) {
        final Process finalProcess = process;
        return executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws InterruptedException {
                return finalProcess.waitFor();
            }
        });
    }

    private void verifyGobbler(Command command, StreamGobbler gobbler, String type) {
        if (gobbler.getException() != null) {
            throw new CommandException("Error inside " + type + " stream", command, gobbler.getException());
        }
    }

    private void closeStreams(Process process) {
        if (process != null) {
            IOUtils.closeQuietly(process.getInputStream());
            IOUtils.closeQuietly(process.getInputStream());
            IOUtils.closeQuietly(process.getOutputStream());
            IOUtils.closeQuietly(process.getErrorStream());
        }
    }

    private void waitUntilFinish(StreamGobbler thread) {
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                System.err.println("InterruptedException while waiting finish of " + thread.toString());
                e.printStackTrace();
            }
        }
    }

    private static class StreamGobbler
    extends Thread {
        private final InputStream is;
        private final StreamConsumer consumer;
        private volatile Exception exception;

        StreamGobbler(InputStream is, StreamConsumer consumer) {
            super("ProcessStreamGobbler");
            this.is = is;
            this.consumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStreamReader isr = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    this.consumeLine(line);
                }
            }
            catch (IOException ioe) {
                this.exception = ioe;
            }
            finally {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(isr);
            }
        }

        private void consumeLine(String line) {
            if (this.exception == null) {
                try {
                    this.consumer.consumeLine(line);
                }
                catch (Exception e) {
                    this.exception = e;
                }
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

