/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.builder;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.report.pdf.entity.RadarGraphic;

public class RadarGraphicBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RadarGraphicBuilder.class);
    private static RadarGraphicBuilder builder;
    private String sonarBaseUrl;

    private RadarGraphicBuilder(String sonarBaseUrl) {
        this.sonarBaseUrl = sonarBaseUrl;
    }

    public static RadarGraphicBuilder getInstance(String sonarBaseUrl) {
        if (builder == null) {
            return new RadarGraphicBuilder(sonarBaseUrl);
        }
        return builder;
    }

    public Image getGraphic(RadarGraphic radarGraphic) {
        Image image = null;
        try {
            String requestUrl = this.sonarBaseUrl + "/chart?ck=xradar&w=210&h=110&c=777777|F8A036&m=100&g=0.25&" + "l=Eff.(" + radarGraphic.getEfficiency() + "%25),Mai.(" + radarGraphic.getMaintainability() + "%25),Por.(" + radarGraphic.getPortability() + "%25),Rel.(" + radarGraphic.getReliavility() + "%25),Usa.(" + radarGraphic.getUsability() + "%25)&" + "v=" + radarGraphic.getEfficiency() + "," + radarGraphic.getMaintainability() + "," + radarGraphic.getPortability() + "," + radarGraphic.getReliavility() + "," + radarGraphic.getUsability();
            LOG.debug("Getting radar graphic: " + requestUrl);
            image = Image.getInstance((String)requestUrl);
            image.setAlignment(5);
        }
        catch (BadElementException e) {
            LOG.error("Can not generate radar graphic", (Throwable)e);
        }
        catch (MalformedURLException e) {
            LOG.error("Can not generate radar graphic", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Can not generate radar graphic", (Throwable)e);
        }
        return image;
    }
}

