/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.builder;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.report.pdf.builder.MeasureBuilder;
import org.sonar.report.pdf.entity.Measure;
import org.sonar.report.pdf.entity.Measures;
import org.sonar.wsclient.Sonar;
import org.sonar.wsclient.services.Metric;
import org.sonar.wsclient.services.MetricQuery;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.ResourceQuery;

public class MeasuresBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(MeasuresBuilder.class);
    private static MeasuresBuilder builder;
    private Sonar sonar;
    private static List<String> measuresKeys;
    private static Integer DEFAULT_SPLIT_LIMIT;

    public MeasuresBuilder(Sonar sonar) {
        this.sonar = sonar;
    }

    public static MeasuresBuilder getInstance(Sonar sonar) {
        if (builder == null) {
            return new MeasuresBuilder(sonar);
        }
        return builder;
    }

    public List<String> getAllMetricKeys() throws HttpDownloader.HttpException, IOException {
        MetricQuery query = MetricQuery.all();
        List<Metric> allMetricKeysNodes = this.sonar.findAll(query);
        ArrayList<String> allMetricKeys = new ArrayList<String>();
        Iterator<Metric> it = allMetricKeysNodes.iterator();
        while (it.hasNext()) {
            allMetricKeys.add(it.next().getKey());
        }
        return allMetricKeys;
    }

    public Measures initMeasuresByProjectKey(String projectKey) throws HttpDownloader.HttpException, IOException {
        Measures measures = new Measures();
        if (measuresKeys == null) {
            measuresKeys = this.getAllMetricKeys();
        }
        if (measuresKeys.size() > DEFAULT_SPLIT_LIMIT) {
            this.initMeasuresSplittingRequests(measures, projectKey);
        } else {
            this.addMeasures(measures, measuresKeys, projectKey);
        }
        return measures;
    }

    private void initMeasuresSplittingRequests(Measures measures, String projectKey) throws HttpDownloader.HttpException, IOException {
        Iterator<String> it = measuresKeys.iterator();
        LOG.debug("Getting " + measuresKeys.size() + " metric measures from Sonar by splitting requests");
        ArrayList<String> twentyMeasures = new ArrayList<String>(20);
        int i = 0;
        while (it.hasNext()) {
            twentyMeasures.add(it.next());
            if (++i % DEFAULT_SPLIT_LIMIT != 0) continue;
            LOG.debug("Split request for: " + twentyMeasures);
            this.addMeasures(measures, twentyMeasures, projectKey);
            i = 0;
            twentyMeasures.clear();
        }
        if (i != 0) {
            LOG.debug("Split request for remain metric measures: " + twentyMeasures);
            this.addMeasures(measures, twentyMeasures, projectKey);
        }
    }

    private void addMeasures(Measures measures, List<String> measuresAsString, String projectKey) throws HttpDownloader.HttpException, IOException {
        String[] measuresAsArray = measuresAsString.toArray(new String[measuresAsString.size()]);
        ResourceQuery query = ResourceQuery.createForMetrics(projectKey, measuresAsArray);
        query.setDepth(0);
        query.setIncludeTrends(true);
        Resource resource = this.sonar.find(query);
        if (resource != null) {
            this.addAllMeasuresFromDocument(measures, resource);
        } else {
            LOG.debug("Empty response when looking for measures: " + measuresAsString.toString());
        }
    }

    private void addAllMeasuresFromDocument(Measures measures, Resource resource) {
        List<org.sonar.wsclient.services.Measure> allNodes = resource.getMeasures();
        Iterator<org.sonar.wsclient.services.Measure> it = allNodes.iterator();
        while (it.hasNext()) {
            this.addMeasureFromNode(measures, it.next());
        }
        try {
            String versionNode;
            Date dateNode = resource.getDate();
            if (dateNode != null) {
                measures.setDate(dateNode);
            }
            if ((versionNode = resource.getVersion()) != null) {
                measures.setVersion(versionNode);
            }
        }
        catch (ParseException e) {
            LOG.error("Can not parse date", (Throwable)e);
        }
    }

    private void addMeasureFromNode(Measures measures, org.sonar.wsclient.services.Measure measureNode) {
        Measure measure = MeasureBuilder.initFromNode(measureNode);
        measures.addMeasure(measure.getKey(), measure);
    }

    static {
        measuresKeys = null;
        DEFAULT_SPLIT_LIMIT = 20;
    }
}

