/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.batch;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.CheckProject;
import org.sonar.api.batch.PostJob;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.Project;
import org.sonar.report.pdf.batch.PDFGenerator;
import org.sonar.report.pdf.util.FileUploader;

public class PDFPostJob
implements PostJob,
CheckProject {
    private static final Logger LOG = LoggerFactory.getLogger(PDFPostJob.class);
    public static final String SKIP_PDF_KEY = "sonar.pdf.skip";
    public static final boolean SKIP_PDF_DEFAULT_VALUE = false;
    public static final String REPORT_TYPE = "report.type";
    public static final String REPORT_TYPE_DEFAULT_VALUE = "workbook";
    public static final String USERNAME = "sonar.pdf.username";
    public static final String USERNAME_DEFAULT_VALUE = "";
    public static final String PASSWORD = "sonar.pdf.password";
    public static final String PASSWORD_DEFAULT_VALUE = "";
    public static final String SONAR_HOST_URL = "sonar.host.url";
    public static final String SONAR_HOST_URL_DEFAULT_VALUE = "http://localhost:9000";
    public static final String SONAR_BRANCH = "sonar.branch";
    public static final String SONAR_BRANCH_DEFAULT_VALUE = null;

    public boolean shouldExecuteOnProject(Project project) {
        return !project.getConfiguration().getBoolean(SKIP_PDF_KEY, false);
    }

    public void executeOn(Project project, SensorContext context) {
        LOG.info("Executing decorator: PDF Report");
        String sonarHostUrl = project.getConfiguration().getString(SONAR_HOST_URL, SONAR_HOST_URL_DEFAULT_VALUE);
        String username = project.getConfiguration().getString(USERNAME, "");
        String password = project.getConfiguration().getString(PASSWORD, "");
        String branch = project.getConfiguration().getString(SONAR_BRANCH, SONAR_BRANCH_DEFAULT_VALUE);
        String reportType = project.getConfiguration().getString(REPORT_TYPE, REPORT_TYPE_DEFAULT_VALUE);
        PDFGenerator generator = new PDFGenerator(project, sonarHostUrl, username, password, branch, reportType);
        generator.execute();
        String path = project.getFileSystem().getSonarWorkingDirectory().getAbsolutePath() + "/" + project.getEffectiveKey().replace(':', '-') + ".pdf";
        File pdf = new File(path);
        if (pdf.exists()) {
            FileUploader.upload(pdf, sonarHostUrl + "/pdf_report/store");
        } else {
            LOG.error("PDF file not found in local filesystem. Report could not be sent to server.");
        }
    }
}

