/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.batch;

import com.lowagie.text.DocumentException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.resources.Project;
import org.sonar.report.pdf.ExecutivePDFReporter;
import org.sonar.report.pdf.PDFReporter;
import org.sonar.report.pdf.TeamWorkbookPDFReporter;
import org.sonar.report.pdf.entity.exception.ReportException;
import org.sonar.report.pdf.util.Credentials;

public class PDFGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(PDFGenerator.class);
    private String sonarHostUrl;
    private String username;
    private String password;
    private String sonarBranch;
    private String reportType;
    private Project project;

    public PDFGenerator(Project project, String sonarHostUrl, String username, String password, String sonarBranch, String reportType) {
        this.project = project;
        this.sonarHostUrl = sonarHostUrl;
        this.username = username;
        this.password = password;
        this.sonarBranch = sonarBranch;
        this.reportType = reportType;
    }

    public void execute() {
        Properties config = new Properties();
        Properties configLang = new Properties();
        try {
            if (this.sonarHostUrl != null) {
                if (this.sonarHostUrl.endsWith("/")) {
                    this.sonarHostUrl = this.sonarHostUrl.substring(0, this.sonarHostUrl.length() - 1);
                }
                config.put("sonar.base.url", this.sonarHostUrl);
                config.put("front.page.logo", "sonar.png");
            } else {
                config.load(this.getClass().getResourceAsStream("/report.properties"));
            }
            configLang.load(this.getClass().getResourceAsStream("/report-texts-en.properties"));
            Credentials credentials = new Credentials(config.getProperty("sonar.base.url"), this.username, this.password);
            String sonarProjectId = this.project.getEffectiveKey();
            String path = this.project.getFileSystem().getSonarWorkingDirectory().getAbsolutePath() + "/" + sonarProjectId.replace(':', '-') + ".pdf";
            if (this.sonarBranch != null) {
                sonarProjectId = sonarProjectId + ":" + this.sonarBranch;
                LOG.info("Branch " + this.sonarBranch + " selected");
            }
            PDFReporter reporter = null;
            if (this.reportType != null) {
                if (this.reportType.equals("executive")) {
                    LOG.info("Executive report type selected");
                    reporter = new ExecutivePDFReporter(credentials, this.getClass().getResource("/sonar.png"), sonarProjectId, config, configLang);
                } else if (this.reportType.equals("workbook")) {
                    LOG.info("Team workbook report type selected");
                    reporter = new TeamWorkbookPDFReporter(credentials, this.getClass().getResource("/sonar.png"), sonarProjectId, config, configLang);
                }
            } else {
                LOG.info("No report type provided. Default report selected (Team workbook)");
                reporter = new TeamWorkbookPDFReporter(credentials, this.getClass().getResource("/sonar.png"), sonarProjectId, config, configLang);
            }
            ByteArrayOutputStream baos = reporter.getReport();
            FileOutputStream fos = new FileOutputStream(new File(path));
            baos.writeTo(fos);
            fos.flush();
            fos.close();
            LOG.info("PDF report generated (see " + sonarProjectId.replace(':', '-') + ".pdf on build output directory)");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            LOG.error("Problem generating PDF file.");
            e.printStackTrace();
        }
        catch (ReportException e) {
            LOG.error("Internal error: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

