/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.report.pdf.Events;
import org.sonar.report.pdf.Header;

public class Toc
extends PdfPageEventHelper {
    private static final Logger LOG = LoggerFactory.getLogger(Events.class);
    private Document toc = new Document(PageSize.A4, 50.0f, 50.0f, 110.0f, 50.0f);
    private ByteArrayOutputStream tocOutputStream;
    private PdfPTable content = new PdfPTable(2);
    private PdfWriter writer;

    public Toc() {
        Rectangle page = this.toc.getPageSize();
        this.content.setTotalWidth(page.getWidth() - this.toc.leftMargin() - this.toc.rightMargin());
        this.content.getDefaultCell().setUseVariableBorders(true);
        this.content.getDefaultCell().setBorderColorBottom(Color.WHITE);
        this.content.getDefaultCell().setBorderColorRight(Color.WHITE);
        this.content.getDefaultCell().setBorderColorLeft(Color.WHITE);
        this.content.getDefaultCell().setBorderColorTop(Color.WHITE);
        this.content.getDefaultCell().setBorderWidthBottom(2.0f);
    }

    public void onChapter(PdfWriter writer, Document document, float position, Paragraph title) {
        this.content.getDefaultCell().setBorderColorBottom(Color.LIGHT_GRAY);
        this.content.getDefaultCell().setHorizontalAlignment(0);
        this.content.getDefaultCell().setUseBorderPadding(true);
        this.content.addCell(new Phrase(title.getContent(), new Font(1, 11.0f)));
        this.content.getDefaultCell().setHorizontalAlignment(2);
        this.content.addCell(new Phrase("Page " + document.getPageNumber(), new Font(1, 11.0f)));
        this.content.getDefaultCell().setBorderColorBottom(Color.WHITE);
        this.content.getDefaultCell().setUseBorderPadding(false);
    }

    public void onChapterEnd(PdfWriter writer, Document document, float position) {
        this.content.addCell("");
        this.content.addCell("");
    }

    public void onSection(PdfWriter writer, Document document, float position, int depth, Paragraph title) {
        this.content.getDefaultCell().setHorizontalAlignment(0);
        switch (depth) {
            case 2: {
                this.content.getDefaultCell().setIndent(10.0f);
                this.content.addCell(new Phrase(title.getContent(), new Font(1, 10.0f)));
                this.content.getDefaultCell().setIndent(0.0f);
                this.content.addCell("");
                break;
            }
            default: {
                this.content.getDefaultCell().setIndent(20.0f);
                this.content.addCell(new Phrase(title.getContent(), new Font(1, 9.0f)));
                this.content.getDefaultCell().setIndent(0.0f);
                this.content.addCell("");
            }
        }
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        try {
            this.toc.add((Element)this.content);
        }
        catch (DocumentException e) {
            LOG.error("Can not add TOC", (Throwable)e);
        }
    }

    public Document getTocDocument() {
        return this.toc;
    }

    public ByteArrayOutputStream getTocOutputStream() {
        return this.tocOutputStream;
    }

    public void setHeader(Header header) {
        this.tocOutputStream = new ByteArrayOutputStream();
        this.writer = null;
        try {
            this.writer = PdfWriter.getInstance((Document)this.toc, (OutputStream)this.tocOutputStream);
            this.writer.setPageEvent((PdfPageEvent)header);
        }
        catch (DocumentException e) {
            LOG.error("Can not add TOC", (Throwable)e);
        }
    }
}

