/*
 * Decompiled with CFR 0.152.
 */
package com.sonarsource.cobol.ebcdic;

import com.sonarsource.cobol.ebcdic.EbcdicToAsciiConverterException;
import com.sonarsource.cobol.ebcdic.FileConverter;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main {
    private static final String INPUT_CHARSET_DEFAULT = "CP1047";
    private static final int FIXED_LENGTH_DEFAULT = -1;
    private Charset input = Main.charsetForName("CP1047");
    private Charset output = Charset.defaultCharset();
    private int fixedLength = -1;
    private File source = null;
    private File destination = null;

    public static void main(String[] args) {
        new Main().parseArguments(args).convert();
    }

    private Main() {
    }

    private Main parseArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-h".equals(arg) || "--help".equals(arg)) {
                Main.printUsage();
                continue;
            }
            if ("-f".equals(arg)) {
                this.checkOptionValueDefinition(args, ++i);
                this.input = Main.charsetForName(args[i]);
                continue;
            }
            if ("-t".equals(arg)) {
                this.checkOptionValueDefinition(args, ++i);
                this.output = Main.charsetForName(args[i]);
                continue;
            }
            if ("-l".equals(arg)) {
                this.checkOptionValueDefinition(args, ++i);
                try {
                    this.fixedLength = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException e) {
                    Main.printError("Expected number for option -l, but got: " + args[i]);
                }
                continue;
            }
            File dir = new File(args[i]);
            if (this.source == null) {
                this.source = dir;
                if (this.source.isDirectory()) continue;
                Main.printError("No such directory: " + this.source);
                continue;
            }
            if (this.destination == null) {
                this.destination = dir;
                continue;
            }
            Main.printError("Unknown option: " + args[i]);
        }
        if (this.source == null) {
            Main.printError("Missing source.");
        }
        if (this.destination == null) {
            Main.printError("Missing destination.");
        }
        return this;
    }

    private void checkOptionValueDefinition(String[] args, int i) {
        if (i >= args.length) {
            Main.printError("Missing argument for option -f");
        }
    }

    private void convert() {
        try {
            FileConverter converter = new FileConverter(this.input, this.output);
            converter.setFixedLength(this.fixedLength);
            List<String> files = Main.listFiles(this.source);
            for (String s : files) {
                File sourceFile = new File(this.source, s);
                File destFile = new File(this.destination, s);
                Main.log("Converting " + sourceFile + " into " + destFile);
                destFile.getParentFile().mkdirs();
                converter.convert(sourceFile, destFile);
            }
            Main.log("SUCCESS");
        }
        catch (EbcdicToAsciiConverterException e) {
            Main.log("Unable to convert files", e);
            Main.log("FAILURE");
        }
    }

    private static Charset charsetForName(String charsetName) {
        try {
            return Charset.forName(charsetName);
        }
        catch (Exception e) {
            Main.printError("Unknown charset: " + charsetName);
            throw new EbcdicToAsciiConverterException("'" + charsetName + "' is an unknown charset.", e);
        }
    }

    private static void printUsage() {
        Main.log("");
        Main.log("Usage: [options] source destination");
        Main.log("");
        Main.log("Convert source into destination.");
        Main.log("  source         relative or absolute path to the directory containing files to be converted");
        Main.log("  destination    relative or absolute path to the directory, which will contain result of conversion");
        Main.log("");
        Main.log("Options:");
        Main.log("  -h, --help     display help information and exit");
        Main.log("  -f encoding    encoding of original text (CP1047 by default)");
        Main.log("  -t encoding    encoding for output (by default the one of the OS: " + Charset.defaultCharset().displayName() + ")");
        Main.log("  -l length      number of characters to split output by lines (disabled by default)");
        System.exit(0);
    }

    private static List<String> listFiles(File dir) {
        ArrayList<String> files = new ArrayList<String>();
        Main.recursivelyListFiles(dir, "", files);
        return files;
    }

    private static void recursivelyListFiles(File dir, String relativePath, List<String> files) {
        for (String s : dir.list()) {
            String path = relativePath + File.separator + s;
            File file = new File(dir, s);
            if (file.isFile() && !file.isHidden()) {
                files.add(path);
                continue;
            }
            if (!file.isDirectory() || file.isHidden()) continue;
            Main.recursivelyListFiles(file, path, files);
        }
    }

    private static void printError(String message) {
        Main.log("");
        Main.log(message);
        Main.printUsage();
    }

    private static void log(String message) {
        System.out.println(message);
    }

    private static void log(String message, Throwable e) {
        System.out.println(message);
        e.printStackTrace();
    }
}

