/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.maven.dotnet.metrics.xml.Command;
import org.apache.maven.dotnet.metrics.xml.Configuration;
import org.apache.maven.dotnet.metrics.xml.Export;
import org.apache.maven.dotnet.metrics.xml.SourceSubdirectoryList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrcMonCommandGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SrcMonCommandGenerator.class);
    private File workDirectory;
    private String sourceMonitorPath;
    private String projectFile;
    private String checkPointName;
    private String sourcePath;
    private List<String> excludedDirectories = new ArrayList<String>();
    private List<String> excludedExtensions = new ArrayList<String>();
    private String generatedFile;

    public void launch() throws Exception {
        logger.info("Launching Source Monitor on the project");
        File commandFile = this.generateCommandFile();
        Object[] cmdArray = new String[]{this.sourceMonitorPath, "/C", commandFile.getAbsolutePath()};
        logger.debug("Executing command: " + Arrays.toString(cmdArray));
        Process process = Runtime.getRuntime().exec((String[])cmdArray, null, this.workDirectory);
        process.waitFor();
    }

    protected File generateCommandFile() throws JAXBException, PropertyException, FileNotFoundException {
        Configuration configuration = new Configuration();
        configuration.setLog(true);
        Command command = new Command();
        command.setProjectFile(this.projectFile);
        command.setProjectLanguage("C#");
        StringBuilder extensions = new StringBuilder("*.cs");
        if (this.excludedExtensions != null && !this.excludedDirectories.isEmpty()) {
            extensions.append("|");
            boolean isFirst = true;
            for (String exclusion : this.excludedExtensions) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    extensions.append(",");
                }
                extensions.append(exclusion.trim());
            }
        }
        command.setFileExtensions(extensions.toString());
        command.setSourceDirectory(this.sourcePath);
        command.setCheckPointName(this.checkPointName);
        command.setIgnoreHeaderFooters(false);
        command.setIncludeSubdirectories(true);
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            XMLGregorianCalendar calendar = factory.newXMLGregorianCalendar(new GregorianCalendar());
            command.setCheckPointDate(calendar.toXMLFormat().substring(0, 19));
        }
        catch (DatatypeConfigurationException e) {
            logger.debug("datat type error", (Throwable)e);
        }
        logger.debug("Code Metrics report :");
        logger.debug(" - OutputType Project File : " + this.projectFile);
        logger.debug(" - Source Directory        : " + this.sourcePath);
        logger.debug(" - Source Monitor path     : " + this.sourceMonitorPath);
        logger.debug(" - Generated report        : " + this.generatedFile);
        SourceSubdirectoryList sourceSubdirectoryList = new SourceSubdirectoryList();
        sourceSubdirectoryList.setExcludeSubdirectories(true);
        String[] excludedArray = new String[this.excludedDirectories.size()];
        for (int idxDirectory = 0; idxDirectory < excludedArray.length; ++idxDirectory) {
            String directory = this.excludedDirectories.get(idxDirectory);
            excludedArray[idxDirectory] = directory.replace('/', '\\');
        }
        sourceSubdirectoryList.setSourceSubdirectory(new String[]{"obj\\debug", "obj\\release"});
        sourceSubdirectoryList.setSourceSubTree(excludedArray);
        command.setSubdirectoryList(sourceSubdirectoryList);
        Export export = new Export();
        export.setFile(this.generatedFile);
        export.setType("2");
        command.setExport(export);
        configuration.setCommands(Collections.singletonList(command));
        Class<Configuration> serializedType = Configuration.class;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{serializedType});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        if (!this.workDirectory.exists()) {
            this.workDirectory.mkdir();
        }
        File commandFile = new File(this.workDirectory, "source-monitor-command.xml");
        FileOutputStream stream = new FileOutputStream(commandFile);
        marshaller.marshal((Object)configuration, (OutputStream)stream);
        logger.debug("Source Monitor command file generated : " + commandFile);
        return commandFile;
    }

    public File getWorkDirectory() {
        return this.workDirectory;
    }

    public void setWorkDirectory(File workDirectory) {
        this.workDirectory = workDirectory;
    }

    public String getSourceMonitorPath() {
        return this.sourceMonitorPath;
    }

    public void setSourceMonitorPath(String sourceMonitorPath) {
        this.sourceMonitorPath = sourceMonitorPath;
    }

    public String getCheckPointName() {
        return this.checkPointName;
    }

    public void setCheckPointName(String checkPointName) {
        this.checkPointName = checkPointName;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public List<String> getExcludedDirectories() {
        return this.excludedDirectories;
    }

    public void setExcludedDirectories(List<String> excludedDirectories) {
        this.excludedDirectories = excludedDirectories;
    }

    public void addExcludedDirectory(String directory) {
        this.excludedDirectories.add(directory);
    }

    public void addExcludedExtension(String extension) {
        this.excludedExtensions.add(extension);
    }

    public String getGeneratedFile() {
        return this.generatedFile;
    }

    public void setGeneratedFile(String generatedFile) {
        this.generatedFile = generatedFile;
    }

    public String getProjectFile() {
        return this.projectFile;
    }

    public void setProjectFile(String projectFile) {
        this.projectFile = projectFile;
    }

    public List<String> getExcludedExtensions() {
        return this.excludedExtensions;
    }

    public void setExcludedExtensions(List<String> excludedExtensions) {
        this.excludedExtensions = excludedExtensions;
    }
}

