/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.dotnet.AbstractDotNetMojo;
import org.apache.maven.dotnet.commons.project.VisualStudioProject;
import org.apache.maven.dotnet.commons.project.VisualStudioSolution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryWalkListener;
import org.codehaus.plexus.util.DirectoryWalker;
import org.codehaus.plexus.util.FileUtils;

public class PackMojo
extends AbstractDotNetMojo {
    private static final String WINDOWS_FILE_SEP = "\\";
    private static final String UNIX_FILE_SEP = "/";
    private static final String PACK_TO_DIR_ATTR = " to-dir=";
    private static final String PACK_FILES_ATTR = " files=";
    private static final int DEFAULT_FILE_PERMISSIONS = 420;
    private File tmpDir;
    private File archive;
    private String packFiles;

    @Override
    protected void executeProject(VisualStudioProject visualProject) throws MojoExecutionException, MojoFailureException {
        this.cleanTmpDir();
        this.createArchive();
    }

    @Override
    protected void executeSolution(VisualStudioSolution visualSolution) throws MojoExecutionException, MojoFailureException {
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.tmpDir = new File(this.project.getBuild().getDirectory());
        if (this.packFiles == null) {
            this.getLog().info((CharSequence)"No file to pack");
            this.archive = this.createArtifactFile();
            try {
                this.archive.createNewFile();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating empty archive file", (Exception)e);
            }
        } else {
            this.cleanTmpDir();
            this.createArchive();
        }
        this.attachArchiveToProject();
    }

    private void attachArchiveToProject() throws MojoExecutionException {
        this.project.getArtifact().setFile(this.archive);
    }

    private void cleanTmpDir() throws MojoExecutionException {
        if (this.tmpDir.exists()) {
            try {
                this.getLog().info((CharSequence)("Cleaning " + this.tmpDir));
                FileUtils.cleanDirectory((File)this.tmpDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not clean directory " + this.tmpDir, (Exception)e);
            }
        } else if (!this.tmpDir.mkdirs()) {
            throw new MojoExecutionException("Could not create directory " + this.tmpDir);
        }
    }

    private void createArchive() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Create archive ");
        this.archive = this.createArtifactFile();
        try {
            ZipArchiver zip = new ZipArchiver();
            zip.setDestFile(this.archive);
            this.doPackFiles(zip);
            zip.createArchive();
        }
        catch (ArchiverException ae) {
            throw new MojoExecutionException("Could not archive directory " + this.tmpDir, (Exception)((Object)ae));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("I/O problem in " + this.tmpDir, (Exception)ioe);
        }
    }

    private File createArtifactFile() {
        Artifact artifact = this.project.getArtifact();
        String archiveFileName = artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getArtifactHandler().getPackaging();
        return new File(this.tmpDir, archiveFileName);
    }

    private void doPackFiles(ZipArchiver zipPack) throws IOException, MojoExecutionException {
        String line;
        BufferedReader br = new BufferedReader(new StringReader(this.packFiles));
        while ((line = br.readLine()) != null) {
            int filesPos;
            line = line.trim().replace('\t', ' ').replace(WINDOWS_FILE_SEP, File.separator).replace(UNIX_FILE_SEP, File.separator);
            while (!StringUtils.isEmpty((String)line) && (filesPos = (line = " " + line + " ").indexOf(PACK_FILES_ATTR)) >= 0) {
                int lastSlashPos;
                int toDirPos = line.indexOf(PACK_TO_DIR_ATTR);
                if (toDirPos < 0) {
                    throw new MojoExecutionException("could not find  to-dir=");
                }
                this.getLog().info((CharSequence)("parsing " + line));
                int endFilesPos = line.indexOf(" ", filesPos + PACK_FILES_ATTR.length());
                int endToDirPos = line.indexOf(" ", toDirPos + PACK_TO_DIR_ATTR.length());
                String source = line.substring(filesPos + PACK_FILES_ATTR.length(), endFilesPos);
                if (source.length() == 0) {
                    throw new MojoExecutionException("bad copy source  files=");
                }
                String targetDir = line.substring(toDirPos + PACK_TO_DIR_ATTR.length(), endToDirPos);
                if (targetDir.length() == 0) {
                    throw new MojoExecutionException("bad copy target  files=");
                }
                String basedir = ".";
                String includePattern = "";
                int starPos = source.indexOf(42);
                if (starPos < 0) {
                    starPos = source.length() - 1;
                }
                if ((lastSlashPos = source.lastIndexOf(File.separator, starPos)) > 0) {
                    basedir = source.substring(0, lastSlashPos);
                    includePattern = source.substring(lastSlashPos + 1);
                } else if (lastSlashPos == 0) {
                    basedir = File.separator;
                    includePattern = source.substring(lastSlashPos + 1);
                } else {
                    includePattern = source;
                }
                CopyFileCollector copyCollector = new CopyFileCollector((AbstractArchiver)zipPack, targetDir);
                DirectoryWalker dw = new DirectoryWalker();
                dw.setBaseDir(new File(basedir));
                dw.addInclude(includePattern);
                dw.addDirectoryWalkListener((DirectoryWalkListener)copyCollector);
                try {
                    dw.scan();
                }
                catch (IllegalStateException e) {
                    throw new MojoExecutionException(basedir + " : " + e.getMessage(), (Exception)e);
                }
                line = line.substring(endToDirPos);
            }
        }
    }

    private class CopyFileCollector
    implements DirectoryWalkListener {
        private String baseDir;
        private String target;
        private String error;
        private AbstractArchiver archiver;

        private CopyFileCollector(AbstractArchiver archiver, String target) {
            this.archiver = archiver;
            this.target = target;
            if (this.target.endsWith(File.separator) && this.target.length() > 1) {
                this.target = this.target.substring(0, this.target.length() - 1);
            }
        }

        public void directoryWalkStarting(File baseDir) {
            this.baseDir = baseDir.getPath();
        }

        public void directoryWalkStep(int percentage, File file) {
            if (this.error != null) {
                return;
            }
            String src = file.getPath();
            if (src.startsWith(this.baseDir)) {
                try {
                    String newpath = this.target + file.getPath().substring(this.baseDir.length());
                    if (newpath.startsWith(File.separator)) {
                        newpath = newpath.substring(1);
                    }
                    PackMojo.this.getLog().info((CharSequence)("adding file " + src + " -> " + newpath));
                    this.archiver.addFile(file, newpath, 420);
                }
                catch (ArchiverException ae) {
                    PackMojo.this.getLog().info((Throwable)ae);
                    this.error = ae.toString();
                }
                catch (StringIndexOutOfBoundsException sa) {
                    PackMojo.this.getLog().info((Throwable)sa);
                    this.error = sa.toString();
                }
            } else {
                PackMojo.this.getLog().info((CharSequence)("bad path to " + file));
            }
        }

        public void directoryWalkFinished() {
        }

        public void debug(String arg0) {
            PackMojo.this.getLog().debug((CharSequence)arg0);
        }
    }
}

