/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.dotnet.AbstractDotNetBuildMojo;
import org.apache.maven.dotnet.commons.project.VisualStudioProject;
import org.apache.maven.dotnet.commons.project.VisualStudioSolution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class MsBuildMojo
extends AbstractDotNetBuildMojo {
    private List<String> parameters;
    private String script;
    private String target;

    private void executeMsBuild() throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isEmpty((String)this.script)) {
            throw new MojoFailureException("Script parameter is mandatory");
        }
        File scriptFile = new File(this.script);
        if (!scriptFile.exists()) {
            throw new MojoExecutionException("Msbuild script file not found : " + scriptFile);
        }
        ArrayList<String> msbuildParameters = new ArrayList<String>();
        msbuildParameters.add(this.toCommandPath(scriptFile));
        if (this.parallelBuild) {
            msbuildParameters.add("/m");
        }
        if (!StringUtils.isEmpty((String)this.target)) {
            msbuildParameters.add("/t:" + this.target);
        }
        if (this.parameters != null) {
            msbuildParameters.addAll(this.parameters);
        }
        File executable = this.getMsBuildCommand();
        this.launchCommand(executable, msbuildParameters, "build", 0);
    }

    @Override
    protected void executeProject(VisualStudioProject visualProject) throws MojoExecutionException, MojoFailureException {
        this.executeMsBuild();
    }

    @Override
    protected void executeSolution(VisualStudioSolution visualSolution) throws MojoExecutionException, MojoFailureException {
        this.executeMsBuild();
    }
}

