/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.dotnet.AbstractCilRuleBasedMojo;
import org.apache.maven.dotnet.commons.project.VisualStudioProject;
import org.apache.maven.dotnet.commons.project.VisualStudioSolution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;

public class GendarmeMojo
extends AbstractCilRuleBasedMojo {
    private static final String MSCORLIB_DLL = "mscorlib.dll";
    private static final String RESOURCE_DIR = "gendarme";
    private static final String EXPORT_PATH = "gendarme-runtime";
    private String gendarmeDirectoryPath;
    private String gendarmeExecutable = "gendarme.exe";
    private String gendarmeReportName;
    private String gendarmeConfigFile;
    private String gendarmeIgnoreFile;
    private String confidence;
    private String severity;
    private File executableFile;

    @Override
    protected void executeSolution(VisualStudioSolution solution) throws MojoFailureException, MojoExecutionException {
        this.prepareExecutable();
        List projects = solution.getProjects();
        for (VisualStudioProject project : projects) {
            if (project.isTest()) continue;
            this.launchReport(project);
        }
    }

    @Override
    protected void executeProject(VisualStudioProject visualProject) throws MojoFailureException, MojoExecutionException {
        if (visualProject.isTest()) {
            this.getLog().info((CharSequence)("No gendarme report generated for the test project " + visualProject.getName()));
            return;
        }
        File assembly = visualProject.getArtifact(this.buildConfigurations);
        if (!assembly.exists()) {
            throw new MojoFailureException("Cannot find the generated assembly to launch gendarme " + assembly);
        }
        this.prepareExecutable();
        this.launchReport(visualProject);
    }

    private void launchReport(VisualStudioProject visualProject) throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        Set assemblies = visualProject.getGeneratedAssemblies(this.buildConfigurations);
        if (assemblies.isEmpty()) {
            log.info((CharSequence)"No assembly to check with Gendarme");
            return;
        }
        if (visualProject.isSilverlightProject()) {
            File destinationDirectory = visualProject.getArtifactDirectory(this.buildConfigurations);
            File silverlightMscorlibLocation = this.getSilverlightMscorlibLocation();
            try {
                File mscorlibFile = new File(silverlightMscorlibLocation, MSCORLIB_DLL);
                FileUtils.copyFileToDirectory((File)mscorlibFile, (File)destinationDirectory);
            }
            catch (IOException e) {
                log.error((Throwable)e);
                throw new MojoFailureException("Cannot copy custom mscorlib.dll file to " + destinationDirectory);
            }
        }
        String projectGendarmeReportName = MessageFormat.format(this.gendarmeReportName, visualProject.getName());
        File reportFile = this.getReportFile(projectGendarmeReportName);
        ArrayList<String> commandArguments = new ArrayList<String>();
        log.debug((CharSequence)("- Report file  : " + reportFile));
        commandArguments.add("--xml");
        commandArguments.add(this.toCommandPath(reportFile));
        if (StringUtils.isNotEmpty((String)this.gendarmeConfigFile)) {
            commandArguments.add("--config");
            commandArguments.add(this.gendarmeConfigFile);
        }
        if (StringUtils.isNotEmpty((String)this.gendarmeIgnoreFile)) {
            commandArguments.add("--ignore");
            commandArguments.add(this.gendarmeIgnoreFile);
        }
        if (this.verbose) {
            commandArguments.add("--v");
        }
        commandArguments.add("--severity");
        commandArguments.add(this.severity);
        commandArguments.add("--confidence");
        commandArguments.add(this.confidence);
        log.debug((CharSequence)"- Scanned assemblies :");
        for (File checkedAssembly : assemblies) {
            log.debug((CharSequence)("   o " + checkedAssembly));
            commandArguments.add(this.toCommandPath(checkedAssembly));
        }
        this.launchCommand(this.executableFile, commandArguments, RESOURCE_DIR, 1);
        log.info((CharSequence)"gendarme report generated");
        if (visualProject.isSilverlightProject()) {
            File destinationDirectory = visualProject.getArtifactDirectory(this.buildConfigurations);
            new File(destinationDirectory, MSCORLIB_DLL).delete();
        }
    }

    private void prepareExecutable() throws MojoExecutionException {
        File gendarmeDirectory = StringUtils.isEmpty((String)this.gendarmeDirectoryPath) ? this.extractFolder(RESOURCE_DIR, EXPORT_PATH, "Gendarme") : new File(this.gendarmeDirectoryPath);
        this.executableFile = new File(gendarmeDirectory, this.gendarmeExecutable);
    }
}

