/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.dotnet.AbstractUnitTestMojo;
import org.apache.maven.dotnet.commons.project.VisualStudioProject;
import org.apache.maven.dotnet.commons.project.VisualStudioSolution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.Commandline;

public class GallioMojo
extends AbstractUnitTestMojo {
    private static final int GALLIO_NO_TEST_EXIT_CODE = 16;
    static final String RESOURCE_DIR = "gallio";
    static final String EXPORT_PATH = "gallio-runtime";
    private File gallioDirectory;
    private String gallioExecutable;
    protected String gallioRunner;
    private String reportFileName;
    protected boolean skip;
    protected boolean skipTests;
    protected boolean testFailureIgnore = false;
    protected String filter;
    private File reportFile;
    private File gallioExe;

    @Override
    protected void executeProject(VisualStudioProject visualProject) throws MojoExecutionException, MojoFailureException {
        throw new MojoFailureException("Unit tests are not supported for a single project");
    }

    @Override
    protected void executeSolution(VisualStudioSolution visualSolution) throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipTests) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return;
        }
        List<File> testAssemblies = this.extractTestAssemblies(visualSolution);
        if (!testAssemblies.isEmpty()) {
            this.launchTests(visualSolution, testAssemblies);
        } else {
            this.getLog().info((CharSequence)("Found no test assembly to launch in the solution " + visualSolution.getName()));
        }
    }

    private int launchTests(VisualStudioSolution visualSolution, List<File> testedAssemblies) throws MojoExecutionException, MojoFailureException {
        String commandName;
        Log log = this.getLog();
        boolean throwsFailure = !this.testFailureIgnore;
        Commandline commandLine = this.generateTestCommand(visualSolution, testedAssemblies);
        int result = this.launchCommand(commandLine, commandName = this.getCommandName(), 16, throwsFailure);
        if (result == 16) {
            log.warn((CharSequence)("No test has been found in assemblies : " + testedAssemblies));
        } else if (result != 0 && this.testFailureIgnore) {
            log.error((CharSequence)("There are test failures!\n\nPlease refer to " + this.getReportDirectory() + " for test results details"));
        }
        return result;
    }

    protected String getCommandName() {
        return "Gallio tests";
    }

    protected Commandline generateTestCommand(VisualStudioSolution solution, List<File> testAssemblies) throws MojoExecutionException, MojoFailureException {
        File gallioExe = this.getGallioExe();
        List<String> arguments = this.generateGallioArgs(testAssemblies);
        this.logCommand(testAssemblies);
        Commandline commandLine = this.generateCommandLine(gallioExe, arguments);
        return commandLine;
    }

    protected void logCommand(List<File> testedAssemblies) throws MojoExecutionException {
        Log log = this.getLog();
        log.info((CharSequence)"Launching Gallio");
        if (log.isDebugEnabled()) {
            File gallioExe = this.getGallioExe();
            log.debug((CharSequence)"Parameters of the Gallio execution");
            log.debug((CharSequence)(" - Gallio             : " + gallioExe));
            log.debug((CharSequence)(" - Test assemblies    : " + testedAssemblies));
            log.debug((CharSequence)(" - Report file        : " + this.reportFile));
            log.debug((CharSequence)" - Report type        : Xml");
        }
    }

    protected List<String> generateGallioArgs(List<File> testedAssemblies) {
        ArrayList<String> arguments = new ArrayList<String>();
        ArrayList<String> fullPaths = new ArrayList<String>();
        for (File testedAssembly : testedAssemblies) {
            fullPaths.add(this.toCommandPath(testedAssembly));
        }
        this.reportFile = this.getReportFile(this.reportFileName);
        if (StringUtils.isNotEmpty((String)this.filter)) {
            arguments.add("/f:" + this.filter);
        }
        arguments.add("/r:" + this.gallioRunner);
        arguments.add("/report-directory:" + this.reportFile.getParent());
        String reportName = this.reportFile.getName();
        if (reportName.toLowerCase().endsWith(".xml")) {
            reportName = reportName.substring(0, reportName.length() - 4);
        }
        arguments.add("/report-name-format:" + reportName);
        arguments.add("/report-type:Xml");
        arguments.addAll(fullPaths);
        return arguments;
    }

    protected File getGallioExe() throws MojoExecutionException {
        if (this.gallioDirectory == null) {
            this.gallioDirectory = this.extractFolder(RESOURCE_DIR, EXPORT_PATH, "Gallio");
            this.gallioExe = new File(this.gallioDirectory, this.gallioExecutable);
        } else if (this.gallioExe == null) {
            this.gallioExe = new File(this.gallioDirectory, "bin/" + this.gallioExecutable);
        }
        return this.gallioExe;
    }
}

