/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.dotnet.AbstractCilRuleBasedMojo;
import org.apache.maven.dotnet.commons.project.VisualStudioProject;
import org.apache.maven.dotnet.commons.project.VisualStudioSolution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class FxCopMojo
extends AbstractCilRuleBasedMojo {
    public static final String DEFAULT_FX_COP_PROJECT = "default-rules.fxcop";
    private static final String RESOURCE_DIR = "fxcop";
    private static final String EXPORT_PATH = "fxcop-runtime";
    private String fxCopDirectoryPath;
    private File fxCopDirectory;
    private String fxCopAdditionalDirectoryPaths;
    private String fxCopExecutable = "FxCopCmd.exe";
    private String fxCopConfigPath;
    private File fxCopConfigFile;
    private String fxCopReportName;
    private String silverlightFxCopReportName;
    private boolean ignoreGeneratedCode = true;
    private File executablePath;

    @Override
    protected void executeSolution(VisualStudioSolution solution) throws MojoFailureException, MojoExecutionException {
        if (solution.isSilverlightUsed()) {
            List<File> slCheckedAssemblies = this.extractSilverlightAssemblies(solution);
            this.launchReport(slCheckedAssemblies, true, false);
        }
        List<File> checkedAssemblies = this.extractNonSilverlightAssemblies(solution);
        this.launchReport(checkedAssemblies, false, solution.isAspUsed());
    }

    @Override
    protected void executeProject(VisualStudioProject visualProject) throws MojoFailureException, MojoExecutionException {
        if (visualProject.isTest()) {
            this.getLog().info((CharSequence)("No FxCop report generated for the test project " + visualProject.getName()));
            return;
        }
        File assembly = visualProject.getArtifact(this.buildConfigurations);
        if (!assembly.exists()) {
            throw new MojoFailureException("Cannot find the generated assembly to launch FxCop " + assembly);
        }
        this.launchReport(Collections.singletonList(assembly), visualProject.isSilverlightProject(), visualProject.isWebProject());
    }

    private void launchReport(List<File> assemblies, boolean silverlightUsed, boolean aspUsed) throws MojoExecutionException, MojoFailureException {
        File reportFile;
        Log log = this.getLog();
        if (assemblies.isEmpty()) {
            log.info((CharSequence)"No assembly to check with FxCop");
            return;
        }
        this.prepareFxCopProject();
        log.info((CharSequence)("Launching FxCop report for " + this.project.getName()));
        this.prepareExecutable();
        ArrayList<String> commandArguments = new ArrayList<String>();
        if (silverlightUsed) {
            reportFile = this.getReportFile(this.silverlightFxCopReportName);
            File silverlightMscorlibLocation = this.getSilverlightMscorlibLocation();
            commandArguments.add("/d:" + this.toCommandPath(silverlightMscorlibLocation));
        } else {
            reportFile = this.getReportFile(this.fxCopReportName);
        }
        log.debug((CharSequence)("- Project file : " + this.fxCopConfigFile));
        commandArguments.add("/p:" + this.toCommandPath(this.fxCopConfigFile));
        log.debug((CharSequence)("- Report file  : " + reportFile));
        commandArguments.add("/out:" + this.toCommandPath(reportFile));
        if (this.ignoreGeneratedCode) {
            commandArguments.add("/ignoregeneratedcode");
        }
        if (this.verbose) {
            commandArguments.add("/v");
        }
        log.debug((CharSequence)"- Scanned assemblies :");
        for (File checkedAssembly : assemblies) {
            log.debug((CharSequence)("   o " + checkedAssembly));
            commandArguments.add("/f:" + this.toCommandPath(checkedAssembly));
        }
        if (!StringUtils.isEmpty((String)this.fxCopAdditionalDirectoryPaths)) {
            String[] pathArray;
            log.debug((CharSequence)"- Additional directories :");
            for (String path : pathArray = StringUtils.split((String)this.fxCopAdditionalDirectoryPaths, (char)';')) {
                File additionalDirectory = new File(path);
                log.debug((CharSequence)("   o " + additionalDirectory));
                commandArguments.add("/d:" + this.toCommandPath(additionalDirectory));
            }
        }
        commandArguments.add("/gac");
        if (aspUsed) {
            commandArguments.add("/aspnet");
        }
        this.launchCommand(this.executablePath, commandArguments, "FxCop", 512);
        log.info((CharSequence)"FxCop report generated");
    }

    private void prepareExecutable() throws MojoExecutionException {
        this.fxCopDirectory = StringUtils.isEmpty((String)this.fxCopDirectoryPath) ? this.extractFolder(RESOURCE_DIR, EXPORT_PATH, "FxCop") : new File(this.fxCopDirectoryPath);
        this.executablePath = new File(this.fxCopDirectory, this.fxCopExecutable);
    }

    protected void prepareFxCopProject() throws MojoExecutionException {
        if (StringUtils.isEmpty((String)this.fxCopConfigPath)) {
            File reportDirectory = this.getReportDirectory();
            this.fxCopConfigFile = this.extractResource(reportDirectory, DEFAULT_FX_COP_PROJECT, DEFAULT_FX_COP_PROJECT, "fxcop project");
        } else {
            this.fxCopConfigFile = new File(this.fxCopConfigPath);
            if (!this.fxCopConfigFile.exists()) {
                throw new MojoExecutionException("Could not find the fxcop project file: " + this.fxCopConfigFile);
            }
        }
        this.getLog().debug((CharSequence)("Using FxCop project file: " + this.fxCopConfigFile));
    }
}

