/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.dotnet.GallioMojo;
import org.apache.maven.dotnet.commons.project.VisualStudioProject;
import org.apache.maven.dotnet.commons.project.VisualStudioSolution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.Commandline;

public class CodeCoverageMojo
extends GallioMojo {
    private static final String GALLIO_RUNNER_4_N_COVER = "NCover3";
    private static final String GALLIO_RUNNER_4_PART_COVER = "IsolatedAppDomain";
    public static final String PART_RESOURCE_DIR = "partcover";
    public static final String PART_EXPORT_PATH = "partcover-runtime";
    protected File partCoverDirectory;
    protected String partCoverExecutable;
    private File executable;
    private String[] coverageExcludes;
    private String coverageReportName;
    private String coverageReportFileName;
    private boolean useNCover;
    private String skippedProjects;

    @Override
    protected void executeProject(VisualStudioProject visualProject) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Cannot launch code coverage on a single project");
    }

    @Override
    protected void executeSolution(VisualStudioSolution solution) throws MojoExecutionException, MojoFailureException {
        this.testFailureIgnore = true;
        super.executeSolution(solution);
        this.getLog().info((CharSequence)"Finished the code coverage");
    }

    @Override
    protected String getCommandName() {
        return "Code coverage";
    }

    @Override
    protected Commandline generateTestCommand(VisualStudioSolution solution, List<File> testedAssemblies) throws MojoExecutionException, MojoFailureException {
        List<String> arguments;
        List projects = solution.getProjects();
        ArrayList<String> coveredAssemblyNames = new ArrayList<String>();
        HashSet<String> skippedProjectSet = new HashSet<String>();
        if (this.skippedProjects != null) {
            skippedProjectSet.addAll(Arrays.asList(StringUtils.split((String)this.skippedProjects, (String)",")));
        }
        for (VisualStudioProject visualProject : projects) {
            if (visualProject.isTest() || skippedProjectSet.contains(visualProject.getName())) continue;
            String assemblyName = visualProject.getAssemblyName();
            coveredAssemblyNames.add(assemblyName);
        }
        File workDir = this.getReportDirectory();
        File reportFile = this.getReportFile(this.coverageReportName);
        File gallioExe = this.getGallioExe();
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)"Parameters of the Coverage execution");
            log.debug((CharSequence)(" - Use NCover ?       : " + this.useNCover));
            log.debug((CharSequence)(" - PartCover          : " + this.executable));
            log.debug((CharSequence)(" - Gallio             : " + gallioExe));
            log.debug((CharSequence)(" - Covered assemblies : " + coveredAssemblyNames));
            log.debug((CharSequence)(" - Exclusions         : " + Arrays.toString(this.coverageExcludes)));
            log.debug((CharSequence)(" - Work directory     : " + workDir));
            log.debug((CharSequence)(" - Report file        : " + reportFile));
        }
        if (this.useNCover) {
            this.gallioRunner = GALLIO_RUNNER_4_N_COVER;
            arguments = this.generateGallioArgs(testedAssemblies);
            arguments.add("/runner-property:NCoverCoverageFile=" + reportFile);
            String includeParam = "/runner-property:NCoverArguments=//ias " + StringUtils.join((Object[])coveredAssemblyNames.toArray(), (String)";");
            arguments.add(includeParam);
            this.executable = this.getGallioExe();
        } else {
            this.gallioRunner = GALLIO_RUNNER_4_PART_COVER;
            List<String> testCommandArgs = this.generateGallioArgs(testedAssemblies);
            this.extractPartCover();
            arguments = new ArrayList<String>();
            arguments.add("--target");
            arguments.add(this.toCommandPath(gallioExe));
            arguments.add("--target-work-dir");
            arguments.add(this.toCommandPath(workDir));
            StringBuilder targetArgsBuilder = new StringBuilder();
            boolean isFirst = true;
            for (String currentArg : testCommandArgs) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    targetArgsBuilder.append(' ');
                }
                String escapedArg = this.escapeQuotes(currentArg);
                targetArgsBuilder.append(escapedArg);
            }
            arguments.add("--target-args");
            arguments.add(targetArgsBuilder.toString());
            for (String assemblyName : coveredAssemblyNames) {
                arguments.add("--include");
                arguments.add("[" + assemblyName + "]*");
            }
            if (this.coverageExcludes != null) {
                for (String exclusion : this.coverageExcludes) {
                    arguments.add("--exclude");
                    arguments.add(exclusion);
                }
            }
            arguments.add("--output");
            arguments.add(this.toCommandPath(reportFile));
        }
        Commandline commandLine = this.generateCommandLine(this.executable, arguments);
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Test-Command:" + commandLine));
        }
        return commandLine;
    }

    public String escapeQuotes(String input) {
        StringBuilder result = new StringBuilder(input.length());
        int len = input.length();
        for (int idxChar = 0; idxChar < len; ++idxChar) {
            char currentChar = input.charAt(idxChar);
            if (currentChar == '\"') {
                result.append('\\');
            } else if (idxChar == 0) {
                result.append("\\\"");
            }
            result.append(currentChar);
            if (currentChar == '\"' || idxChar != len - 1) continue;
            result.append("\\\"");
        }
        return result.toString();
    }

    private void extractPartCover() throws MojoExecutionException, MojoFailureException {
        if (this.partCoverDirectory == null) {
            this.partCoverDirectory = this.extractFolder(PART_RESOURCE_DIR, PART_EXPORT_PATH, "PartCover");
        }
        this.executable = new File(this.partCoverDirectory, this.partCoverExecutable);
    }
}

