/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.dotnet.AbstractDotNetBuildMojo;
import org.apache.maven.dotnet.commons.project.ArtifactType;
import org.apache.maven.dotnet.commons.project.VisualStudioProject;
import org.apache.maven.dotnet.commons.project.VisualStudioSolution;
import org.apache.maven.dotnet.commons.project.WebVisualStudioProject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;

public class CleanMojo
extends AbstractDotNetBuildMojo {
    @Override
    protected void executeProject(VisualStudioProject visualProject) throws MojoExecutionException, MojoFailureException {
        if (visualProject.getType() != ArtifactType.WEB) {
            File csprojFile = visualProject.getProjectFile();
            this.launchClean(csprojFile);
        }
    }

    @Override
    protected void executeSolution(VisualStudioSolution visualSolution) throws MojoExecutionException, MojoFailureException {
        File solutionFile = visualSolution.getSolutionFile();
        this.launchClean(solutionFile);
    }

    public void launchClean(File file) throws MojoExecutionException, MojoFailureException {
        File executable = this.getMsBuildCommand();
        Log log = this.getLog();
        log.info((CharSequence)("Launching the cleaning of " + file));
        log.debug((CharSequence)(" - Tool Version  : " + this.toolVersion));
        log.debug((CharSequence)(" - MsBuild exe   : " + executable));
        List visualStudioProjects = this.getVisualSolution().getProjects();
        for (VisualStudioProject visualStudioProject : visualStudioProjects) {
            File sonarWorkDir = new File(visualStudioProject.getDirectory(), "target");
            if (sonarWorkDir.isDirectory()) {
                log.info((CharSequence)("Delete Sonar working directory : " + sonarWorkDir));
                try {
                    FileUtils.deleteDirectory((File)sonarWorkDir);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("error while cleaning project " + visualStudioProject, (Exception)e);
                }
            }
            if (!(visualStudioProject instanceof WebVisualStudioProject)) continue;
            WebVisualStudioProject webProject = (WebVisualStudioProject)visualStudioProject;
            log.info((CharSequence)("Cleaning precompiled asp.net dlls for project " + webProject));
            List<String> configurations = this.getBuildConfigurations();
            for (String configuration : configurations) {
                File precompilationDirectory = webProject.getWebPrecompilationDirectory(configuration);
                try {
                    if (precompilationDirectory == null || !precompilationDirectory.exists()) continue;
                    FileUtils.cleanDirectory((File)precompilationDirectory);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("error while cleaning web project " + visualStudioProject, (Exception)e);
                }
            }
        }
        List<String> configurations = this.getBuildConfigurations();
        for (String configuration : configurations) {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add(this.toCommandPath(file));
            arguments.add("/t:Clean");
            arguments.add("/p:Configuration=" + configuration);
            this.launchCommand(executable, arguments, "clean", 0);
        }
        log.info((CharSequence)"Cleaning done!");
    }
}

