/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.dotnet.AbstractDotNetMojo;
import org.apache.maven.dotnet.commons.project.VisualStudioProject;
import org.apache.maven.dotnet.commons.project.VisualStudioSolution;
import org.apache.maven.dotnet.commons.project.WebVisualStudioProject;
import org.apache.maven.plugin.MojoFailureException;

public abstract class AbstractCilRuleBasedMojo
extends AbstractDotNetMojo {
    protected File silverlight_3_MscorlibLocation;
    protected File silverlight_4_MscorlibLocation;
    protected String silverlightVersion;
    protected boolean verbose;

    protected File getSilverlightMscorlibLocation() throws MojoFailureException {
        File silverlightMscorlibLocation = "3".equals(this.silverlightVersion) ? this.silverlight_3_MscorlibLocation : this.silverlight_4_MscorlibLocation;
        if (silverlightMscorlibLocation == null || !silverlightMscorlibLocation.exists() || !silverlightMscorlibLocation.isDirectory()) {
            throw new MojoFailureException("incorrect silverlight " + this.silverlightVersion + " mscorlib path: " + silverlightMscorlibLocation);
        }
        return silverlightMscorlibLocation;
    }

    private List<File> extractAssemblies(VisualStudioSolution solution, Boolean silverlightFilter) throws MojoFailureException {
        List projects = solution.getProjects();
        ArrayList<File> assemblies = new ArrayList<File>();
        HashSet<String> skippedProjectSet = new HashSet<String>();
        if (this.skippedProjects != null) {
            skippedProjectSet.addAll(Arrays.asList(StringUtils.split((String)this.skippedProjects, (char)',')));
        }
        for (VisualStudioProject visualStudioProject : projects) {
            if (visualStudioProject.isTest()) {
                this.getLog().info((CharSequence)("Skipping the test project " + visualStudioProject.getName()));
                continue;
            }
            if (skippedProjectSet.contains(visualStudioProject.getName())) {
                this.getLog().info((CharSequence)("Skipping project " + visualStudioProject.getName()));
                continue;
            }
            if (visualStudioProject instanceof WebVisualStudioProject) {
                WebVisualStudioProject webProject = (WebVisualStudioProject)visualStudioProject;
                assemblies.addAll(webProject.getGeneratedAssemblies(this.buildConfigurations));
                continue;
            }
            if (silverlightFilter != null && !silverlightFilter.equals(visualStudioProject.isSilverlightProject())) continue;
            File assembly = visualStudioProject.getArtifact(this.buildConfigurations);
            if (assembly.exists()) {
                assemblies.add(assembly);
                continue;
            }
            this.getLog().info((CharSequence)("Skipping the non generated assembly: " + assembly));
        }
        return assemblies;
    }

    protected final List<File> extractAssemblies(VisualStudioSolution solution) throws MojoFailureException {
        return this.extractAssemblies(solution, null);
    }

    protected final List<File> extractSilverlightAssemblies(VisualStudioSolution solution) throws MojoFailureException {
        return this.extractAssemblies(solution, true);
    }

    protected final List<File> extractNonSilverlightAssemblies(VisualStudioSolution solution) throws MojoFailureException {
        return this.extractAssemblies(solution, false);
    }
}

