/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.xunit;

import com.ctc.wstx.exc.WstxEOFException;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.in.ElementFilter;
import org.codehaus.staxmate.in.SMFilter;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.StaxParser;
import org.sonar.plugins.cxx.utils.EmptyReportException;
import org.sonar.plugins.cxx.xunit.TestCase;
import org.sonar.plugins.cxx.xunit.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuiteParser
implements StaxParser.XmlStreamHandler {
    private Map<String, TestSuite> testSuites = new HashMap<String, TestSuite>();

    public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
        SMInputCursor testSuiteCursor = rootCursor.constructDescendantCursor((SMFilter)new ElementFilter("testsuite"));
        try {
            testSuiteCursor.getNext();
        }
        catch (WstxEOFException eofExc) {
            throw new EmptyReportException();
        }
        do {
            String testSuiteClassName = testSuiteCursor.getAttrValue("name");
            String testFileName = testSuiteCursor.getAttrValue("filename");
            SMInputCursor testCaseCursor = testSuiteCursor.childElementCursor("testcase");
            while (testCaseCursor.getNext() != null) {
                String testClassName = this.getClassname(testCaseCursor, testSuiteClassName);
                String testSuiteKey = this.isValidKey(testFileName) ? testFileName : testClassName;
                TestSuite report = this.testSuites.get(testSuiteKey);
                if (report == null) {
                    report = new TestSuite(testSuiteKey);
                    this.testSuites.put(testSuiteKey, report);
                }
                report.addTestCase(this.parseTestCaseTag(testCaseCursor));
            }
        } while (testSuiteCursor.getNext() != null);
    }

    private boolean isValidKey(String key) {
        return key != null && !"".equals(key);
    }

    public Collection<TestSuite> getParsedReports() {
        return this.testSuites.values();
    }

    private String getClassname(SMInputCursor testCaseCursor, String defaultClassname) throws XMLStreamException {
        String testClassName = testCaseCursor.getAttrValue("classname");
        return testClassName == null ? defaultClassname : testClassName;
    }

    private TestCase parseTestCaseTag(SMInputCursor testCaseCursor) throws XMLStreamException {
        String name = this.parseTestCaseName(testCaseCursor);
        Double time = this.parseTime(testCaseCursor);
        String status = "ok";
        String stack = "";
        String msg = "";
        SMInputCursor childCursor = testCaseCursor.childElementCursor();
        if (childCursor.getNext() != null) {
            String elementName = childCursor.getLocalName();
            if (elementName.equals("skipped")) {
                status = "skipped";
            } else if (elementName.equals("failure")) {
                status = "failure";
                msg = childCursor.getAttrValue("message");
                stack = childCursor.collectDescendantText();
            } else if (elementName.equals("error")) {
                status = "error";
                msg = childCursor.getAttrValue("message");
                stack = childCursor.collectDescendantText();
            }
        }
        return new TestCase(name, time.intValue(), status, stack, msg);
    }

    private double parseTime(SMInputCursor testCaseCursor) throws XMLStreamException {
        double time = 0.0;
        try {
            Double tmp;
            String sTime = testCaseCursor.getAttrValue("time");
            if (!StringUtils.isEmpty((String)sTime) && !Double.isNaN(tmp = Double.valueOf(ParsingUtils.parseNumber((String)sTime, (Locale)Locale.ENGLISH)))) {
                time = ParsingUtils.scaleValue((double)(tmp * 1000.0), (int)3);
            }
        }
        catch (ParseException e) {
            throw new XMLStreamException(e);
        }
        return time;
    }

    private String parseTestCaseName(SMInputCursor testCaseCursor) throws XMLStreamException {
        String name = testCaseCursor.getAttrValue("name");
        String classname = testCaseCursor.getAttrValue("classname");
        if (classname != null) {
            name = classname + "/" + name;
        }
        return name;
    }
}

