/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.xunit;

import com.sonar.sslr.squid.SquidAstVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.sonar.api.batch.CoverageExtension;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.StaxParser;
import org.sonar.cxx.CxxAstScanner;
import org.sonar.cxx.CxxConfiguration;
import org.sonar.plugins.cxx.CxxLanguage;
import org.sonar.plugins.cxx.utils.CxxReportSensor;
import org.sonar.plugins.cxx.utils.CxxUtils;
import org.sonar.plugins.cxx.xunit.TestSuite;
import org.sonar.plugins.cxx.xunit.TestSuiteParser;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxxXunitSensor
extends CxxReportSensor {
    public static final String REPORT_PATH_KEY = "sonar.cxx.xunit.reportPath";
    public static final String XSLT_URL_KEY = "sonar.cxx.xunit.xsltURL";
    private static final String DEFAULT_REPORT_PATH = "xunit-reports/xunit-result-*.xml";
    private String xsltURL = null;
    private CxxLanguage lang = null;
    private Map<String, String> classDeclTable = new TreeMap<String, String>();
    private Map<String, String> classImplTable = new TreeMap<String, String>();
    static Pattern classNameMatchingPattern = Pattern.compile("(?:\\w*::)*?(\\w+?)::\\w+?:\\d+$");

    public CxxXunitSensor(Settings conf, CxxLanguage cxxLang) {
        super(conf);
        this.lang = cxxLang;
        this.xsltURL = conf.getString(XSLT_URL_KEY);
    }

    @DependsUpon
    public Class<?> dependsUponCoverageSensors() {
        return CoverageExtension.class;
    }

    @Override
    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    @Override
    protected String defaultReportPath() {
        return DEFAULT_REPORT_PATH;
    }

    @Override
    public void analyse(Project project, SensorContext context) {
        this.buildLookupTables(project);
        super.analyse(project, context);
    }

    @Override
    protected void processReport(Project project, SensorContext context, File report) throws IOException, TransformerException, XMLStreamException {
        this.parseReport(project, context, this.transformReport(report));
    }

    @Override
    protected void handleNoReportsCase(SensorContext context) {
        context.saveMeasure(CoreMetrics.TESTS, Double.valueOf(0.0));
    }

    File transformReport(File report) throws IOException, TransformerException {
        File transformed = report;
        if (this.xsltURL != null) {
            CxxUtils.LOG.debug("Transforming the report using xslt '{}'", (Object)this.xsltURL);
            InputStream inputStream = this.getClass().getResourceAsStream("/xsl/" + this.xsltURL);
            if (inputStream == null) {
                URL url = new URL(this.xsltURL);
                inputStream = url.openStream();
            }
            StreamSource xsl = new StreamSource(inputStream);
            TransformerFactory factory = TransformerFactory.newInstance();
            Templates template = factory.newTemplates(xsl);
            Transformer xformer = template.newTransformer();
            xformer.setOutputProperty("indent", "yes");
            StreamSource source = new StreamSource(report);
            transformed = new File(report.getAbsolutePath() + ".after_xslt");
            StreamResult result = new StreamResult(transformed);
            xformer.transform(source, result);
        } else {
            CxxUtils.LOG.debug("Transformation skipped: no xslt given");
        }
        return transformed;
    }

    private void parseReport(Project project, SensorContext context, File report) throws XMLStreamException, IOException {
        CxxUtils.LOG.info("Parsing report '{}'", (Object)report);
        TestSuiteParser parserHandler = new TestSuiteParser();
        StaxParser parser = new StaxParser((StaxParser.XmlStreamHandler)parserHandler, false);
        parser.parse(report);
        for (TestSuite fileReport : parserHandler.getParsedReports()) {
            String fileKey = fileReport.getKey();
            double testsCount = fileReport.getTests() - fileReport.getSkipped();
            try {
                org.sonar.api.resources.File resource = this.getTestFile(project, context, fileKey);
                this.saveTestMetrics(context, resource, fileReport, testsCount);
            }
            catch (SonarException ex) {
                CxxUtils.LOG.warn("Cannot save test metrics for '{}', details: {}", (Object)fileKey, (Object)ex);
            }
        }
    }

    private void saveTestMetrics(SensorContext context, org.sonar.api.resources.File resource, TestSuite fileReport, double testsCount) {
        context.saveMeasure((Resource)resource, CoreMetrics.SKIPPED_TESTS, Double.valueOf(fileReport.getSkipped()));
        context.saveMeasure((Resource)resource, CoreMetrics.TESTS, Double.valueOf(testsCount));
        context.saveMeasure((Resource)resource, CoreMetrics.TEST_ERRORS, Double.valueOf(fileReport.getErrors()));
        context.saveMeasure((Resource)resource, CoreMetrics.TEST_FAILURES, Double.valueOf(fileReport.getFailures()));
        context.saveMeasure((Resource)resource, CoreMetrics.TEST_EXECUTION_TIME, Double.valueOf(fileReport.getTime()));
        double passedTests = testsCount - (double)fileReport.getErrors() - (double)fileReport.getFailures();
        if (testsCount > 0.0) {
            double percentage = passedTests * 100.0 / testsCount;
            context.saveMeasure((Resource)resource, CoreMetrics.TEST_SUCCESS_DENSITY, Double.valueOf(ParsingUtils.scaleValue((double)percentage)));
        }
        context.saveMeasure((Resource)resource, new Measure(CoreMetrics.TEST_DATA, fileReport.getDetails()));
    }

    private org.sonar.api.resources.File getTestFile(Project project, SensorContext context, String fileKey) {
        org.sonar.api.resources.File resource = org.sonar.api.resources.File.fromIOFile((File)new File(fileKey), (List)project.getFileSystem().getTestDirs());
        if (context.getResource((Resource)resource) == null) {
            String filePath = this.lookupFilePath(fileKey);
            resource = org.sonar.api.resources.File.fromIOFile((File)new File(filePath), (List)project.getFileSystem().getTestDirs());
            if (context.getResource((Resource)resource) == null) {
                CxxUtils.LOG.debug("Cannot find the source file for test '{}', creating a dummy one", (Object)fileKey);
                resource = this.createVirtualFile(context, fileKey);
            }
        } else {
            CxxUtils.LOG.debug("Assigning the test '{}' to resource '{}'", (Object)fileKey, (Object)resource.getKey());
        }
        return resource;
    }

    private org.sonar.api.resources.File createVirtualFile(SensorContext context, String fileKey) {
        org.sonar.api.resources.File file = new org.sonar.api.resources.File(fileKey);
        file.setLanguage((Language)this.lang);
        file.setQualifier("UTS");
        context.saveSource((Resource)file, "<The sources could not be found. Consult the log file for details>");
        return file;
    }

    String lookupFilePath(String key) {
        String path = this.classImplTable.get(key);
        if (path == null) {
            path = this.classDeclTable.get(key);
        }
        return path != null ? path : key;
    }

    void buildLookupTables(Project project) {
        List files = project.getFileSystem().testFiles(new String[]{"c++"});
        CxxConfiguration cxxConf = new CxxConfiguration(project.getFileSystem().getSourceCharset());
        cxxConf.setBaseDir(project.getFileSystem().getBasedir().getAbsolutePath());
        cxxConf.setDefines(this.conf.getStringArray("sonar.cxx.defines"));
        cxxConf.setIncludeDirectories(this.conf.getStringArray("sonar.cxx.include_directories"));
        for (InputFile file : files) {
            SourceFile source = CxxAstScanner.scanSingleFileConfig((File)file.getFile(), (CxxConfiguration)cxxConf, (SquidAstVisitor[])new SquidAstVisitor[0]);
            if (!source.hasChildren()) continue;
            for (SourceCode child : source.getChildren()) {
                String clsName;
                if (child instanceof SourceClass) {
                    this.classDeclTable.put(child.getName(), file.getFile().getPath());
                    continue;
                }
                if (!(child instanceof SourceFunction) || (clsName = this.matchClassName(child.getKey())) == null) continue;
                this.classImplTable.put(clsName, file.getFile().getPath());
            }
        }
        this.filterMapUsingKeyList(this.classImplTable, this.classDeclTable.keySet());
    }

    private Map<String, String> filterMapUsingKeyList(Map<String, String> map, Collection keys) {
        return map;
    }

    String matchClassName(String fullQualFunctionName) {
        Matcher matcher = classNameMatchingPattern.matcher(fullQualFunctionName);
        String clsname = null;
        if (matcher.matches()) {
            clsname = matcher.group(1);
        }
        return clsname;
    }
}

