/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.valgrind;

import com.ctc.wstx.exc.WstxEOFException;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.utils.StaxParser;
import org.sonar.plugins.cxx.utils.EmptyReportException;
import org.sonar.plugins.cxx.valgrind.ValgrindError;
import org.sonar.plugins.cxx.valgrind.ValgrindFrame;
import org.sonar.plugins.cxx.valgrind.ValgrindStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ValgrindReportParser {
    public Set<ValgrindError> parseReport(File report) throws XMLStreamException {
        ValgrindReportStreamHandler streamHandler = new ValgrindReportStreamHandler();
        new StaxParser((StaxParser.XmlStreamHandler)streamHandler).parse(report);
        return streamHandler.valgrindErrors;
    }

    private ValgrindError parseErrorTag(SMInputCursor error) throws XMLStreamException {
        SMInputCursor child = error.childElementCursor();
        String kind = null;
        String text = null;
        ValgrindStack stack = null;
        while (child.getNext() != null) {
            String tagName = child.getLocalName();
            if ("kind".equalsIgnoreCase(tagName)) {
                kind = child.getElemStringValue();
                continue;
            }
            if ("xwhat".equalsIgnoreCase(tagName)) {
                text = child.childElementCursor("text").advance().getElemStringValue();
                continue;
            }
            if ("what".equalsIgnoreCase(tagName)) {
                text = child.getElemStringValue();
                continue;
            }
            if (!"stack".equalsIgnoreCase(tagName)) continue;
            stack = this.parseStackTag(child);
        }
        if (text == null || kind == null || stack == null) {
            String msg = "Valgrind error is incomplete: we require all of 'kind', '*what.text' and 'stack'";
            child.throwStreamException(msg);
        }
        return new ValgrindError(kind, text, stack);
    }

    private ValgrindStack parseStackTag(SMInputCursor child) throws XMLStreamException {
        ValgrindStack stack = new ValgrindStack();
        SMInputCursor frameCursor = child.childElementCursor("frame");
        while (frameCursor.getNext() != null) {
            SMInputCursor frameChild = frameCursor.childElementCursor();
            String ip = null;
            String obj = null;
            String fn = null;
            String dir = null;
            String file = null;
            String line = null;
            while (frameChild.getNext() != null) {
                String tagName = frameChild.getLocalName();
                if ("ip".equalsIgnoreCase(tagName)) {
                    ip = frameChild.getElemStringValue();
                    continue;
                }
                if ("obj".equalsIgnoreCase(tagName)) {
                    obj = frameChild.getElemStringValue();
                    continue;
                }
                if ("fn".equalsIgnoreCase(tagName)) {
                    fn = frameChild.getElemStringValue();
                    continue;
                }
                if ("dir".equalsIgnoreCase(tagName)) {
                    dir = frameChild.getElemStringValue();
                    continue;
                }
                if ("file".equalsIgnoreCase(tagName)) {
                    file = frameChild.getElemStringValue();
                    continue;
                }
                if (!"line".equalsIgnoreCase(tagName)) continue;
                line = frameChild.getElemStringValue();
            }
            stack.addFrame(new ValgrindFrame(ip, obj, fn, dir, file, line));
        }
        return stack;
    }

    private class ValgrindReportStreamHandler
    implements StaxParser.XmlStreamHandler {
        Set<ValgrindError> valgrindErrors = new HashSet<ValgrindError>();

        private ValgrindReportStreamHandler() {
        }

        public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
            try {
                rootCursor.advance();
            }
            catch (WstxEOFException eofExc) {
                throw new EmptyReportException();
            }
            SMInputCursor errorCursor = rootCursor.childElementCursor("error");
            while (errorCursor.getNext() != null) {
                this.valgrindErrors.add(ValgrindReportParser.this.parseErrorTag(errorCursor));
            }
        }
    }
}

