/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.valgrind;

import java.io.File;
import org.apache.commons.lang.builder.HashCodeBuilder;

class ValgrindFrame {
    private String ip = "???";
    private String obj = "";
    private String fn = "???";
    private String dir = "";
    private String file = "";
    private String line = "";

    public ValgrindFrame(String ip, String obj, String fn, String dir, String file, String line) {
        if (ip != null) {
            this.ip = ip;
        }
        if (obj != null) {
            this.obj = obj;
        }
        if (fn != null) {
            this.fn = fn;
        }
        if (dir != null) {
            this.dir = dir;
        }
        if (file != null) {
            this.file = file;
        }
        if (line != null) {
            this.line = line;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.ip).append(": ").append(this.fn);
        if (this.isLocationKnown()) {
            builder.append(" (").append("".equals(this.file) ? "in " + this.obj : this.file + this.getLineStr()).append(")");
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValgrindFrame other = (ValgrindFrame)o;
        return this.hashCode() == other.hashCode();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.obj).append((Object)this.fn).append((Object)this.dir).append((Object)this.file).append((Object)this.line).toHashCode();
    }

    String getPath() {
        return new File(this.dir, this.file).getPath();
    }

    String getDir() {
        return this.dir;
    }

    String getLine() {
        return this.line;
    }

    private boolean isLocationKnown() {
        return !"".equals(this.file) || !"".equals(this.obj);
    }

    private String getLineStr() {
        return "".equals(this.line) ? "" : ":" + this.line;
    }
}

