/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RuleQuery;
import org.sonar.api.rules.Violation;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.cxx.utils.CxxUtils;
import org.sonar.plugins.cxx.utils.EmptyReportException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CxxReportSensor
implements Sensor {
    private RuleFinder ruleFinder;
    protected Settings conf = null;

    public CxxReportSensor() {
    }

    public CxxReportSensor(Settings conf) {
        this.conf = conf;
    }

    public CxxReportSensor(RuleFinder ruleFinder, Settings conf) {
        this.ruleFinder = ruleFinder;
        this.conf = conf;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return "c++".equals(project.getLanguageKey());
    }

    public void analyse(Project project, SensorContext context) {
        try {
            List<File> reports = this.getReports(this.conf, project.getFileSystem().getBasedir().getPath(), this.reportPathKey(), this.defaultReportPath());
            for (File report : reports) {
                CxxUtils.LOG.info("Processing report '{}'", (Object)report);
                try {
                    this.processReport(project, context, report);
                }
                catch (EmptyReportException e) {
                    CxxUtils.LOG.warn("The report '{}' seems to be empty, ignoring.", (Object)report);
                }
            }
            if (reports.isEmpty()) {
                this.handleNoReportsCase(context);
            }
        }
        catch (Exception e) {
            String msg = "Cannot feed the data into sonar, details: '" + e + "'";
            throw new SonarException(msg, (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public String getStringProperty(String name, String def) {
        String value = this.conf.getString(name);
        if (value == null) {
            value = def;
        }
        return value;
    }

    protected List<File> getReports(Settings conf, String baseDirPath, String reportPathPropertyKey, String defaultReportPath) {
        String reportPath = conf.getString(reportPathPropertyKey);
        if (reportPath == null) {
            reportPath = defaultReportPath;
        }
        CxxUtils.LOG.debug("Using pattern '{}' to find reports", (Object)reportPath);
        DirectoryScanner scanner = new DirectoryScanner();
        String[] includes = new String[]{reportPath};
        scanner.setIncludes(includes);
        scanner.setBasedir(new File(baseDirPath));
        scanner.scan();
        String[] relPaths = scanner.getIncludedFiles();
        ArrayList<File> reports = new ArrayList<File>();
        for (String relPath : relPaths) {
            reports.add(new File(baseDirPath, relPath));
        }
        return reports;
    }

    protected void saveViolation(Project project, SensorContext context, String ruleRepoKey, String file, String line, String ruleId, String msg) {
        RuleQuery ruleQuery = RuleQuery.create().withRepositoryKey(ruleRepoKey).withKey(ruleId);
        Rule rule = this.ruleFinder.find(ruleQuery);
        if (rule != null) {
            org.sonar.api.resources.File resource = org.sonar.api.resources.File.fromIOFile((File)new File(file), (Project)project);
            if (context.getResource((Resource)resource) != null) {
                Violation violation = Violation.create((Rule)rule, (Resource)resource).setMessage(msg);
                if (line != null) {
                    try {
                        int linenr = Integer.parseInt(line);
                        violation.setLineId(Integer.valueOf(linenr));
                    }
                    catch (NumberFormatException nfe) {
                        CxxUtils.LOG.warn("Skipping invalid line number: {}", (Object)line);
                    }
                }
                context.saveViolation(violation);
            } else {
                CxxUtils.LOG.debug("Cannot find the file '{}', skipping violation '{}'", (Object)file, (Object)msg);
            }
        } else {
            CxxUtils.LOG.warn("Cannot find the rule {}, skipping violation", (Object)ruleId);
        }
    }

    protected void processReport(Project project, SensorContext context, File report) throws Exception {
    }

    protected void handleNoReportsCase(SensorContext context) {
    }

    protected String reportPathKey() {
        return "";
    }

    protected String defaultReportPath() {
        return "";
    }
}

