/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.utils;

import java.io.File;
import java.util.List;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.plugins.cxx.CxxLanguage;

public abstract class CxxFileSensor
implements Sensor {
    private CxxLanguage language = new CxxLanguage();

    public boolean shouldExecuteOnProject(Project project) {
        return "c++".equals(project.getLanguageKey());
    }

    public void analyse(Project project, SensorContext context) {
        List sourceFiles = project.getFileSystem().mainFiles(new String[]{"c++"});
        for (InputFile inputFile : sourceFiles) {
            if (!this.shouldParseFile(inputFile.getFile())) continue;
            this.parseFile(inputFile, project, context);
        }
    }

    protected boolean shouldParseFile(File file) {
        for (String suffix : this.language.getSourceFileSuffixes()) {
            if (!file.getAbsolutePath().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    protected abstract void parseFile(InputFile var1, Project var2, SensorContext var3);
}

