/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.squid;

import com.google.common.collect.Lists;
import com.sonar.sslr.squid.AstScanner;
import com.sonar.sslr.squid.SquidAstVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.AnnotationCheckFactory;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.InputFileUtils;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Violation;
import org.sonar.cxx.CxxAstScanner;
import org.sonar.cxx.CxxConfiguration;
import org.sonar.cxx.api.CxxGrammar;
import org.sonar.cxx.api.CxxMetric;
import org.sonar.cxx.checks.CheckList;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceFunction;
import org.sonar.squid.indexer.QueryByParent;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CxxSquidSensor
implements Sensor {
    private static final Number[] FUNCTIONS_DISTRIB_BOTTOM_LIMITS = new Number[]{1, 2, 4, 6, 8, 10, 12, 20, 30};
    private static final Number[] FILES_DISTRIB_BOTTOM_LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};
    private final AnnotationCheckFactory annotationCheckFactory;
    private Project project;
    private SensorContext context;
    private AstScanner<CxxGrammar> scanner;
    private Configuration conf;

    public CxxSquidSensor(RulesProfile profile, Configuration conf) {
        this.annotationCheckFactory = AnnotationCheckFactory.create((RulesProfile)profile, (String)"cxx", (Collection)CheckList.getChecks());
        this.conf = conf;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return "c++".equals(project.getLanguageKey());
    }

    public void analyse(Project project, SensorContext context) {
        this.project = project;
        this.context = context;
        Collection squidChecks = this.annotationCheckFactory.getChecks();
        ArrayList visitors = Lists.newArrayList((Iterable)squidChecks);
        this.scanner = CxxAstScanner.create((CxxConfiguration)this.createConfiguration(project, this.conf), (SquidAstVisitor[])visitors.toArray(new SquidAstVisitor[visitors.size()]));
        this.scanner.scanFiles((Collection)InputFileUtils.toFiles((Collection)project.getFileSystem().mainFiles(new String[]{"c++"})));
        Collection squidSourceFiles = this.scanner.getIndex().search(new Query[]{new QueryByType(SourceFile.class)});
        this.save(squidSourceFiles);
    }

    private CxxConfiguration createConfiguration(Project project, Configuration conf) {
        CxxConfiguration cxxConf = new CxxConfiguration(project.getFileSystem().getSourceCharset());
        cxxConf.setBaseDir(project.getFileSystem().getBasedir().getAbsolutePath());
        cxxConf.setDefines(conf.getStringArray("sonar.cxx.defines"));
        cxxConf.setIncludeDirectories(conf.getStringArray("sonar.cxx.include_directories"));
        return cxxConf;
    }

    private void save(Collection<SourceCode> squidSourceFiles) {
        for (SourceCode squidSourceFile : squidSourceFiles) {
            SourceFile squidFile = (SourceFile)squidSourceFile;
            org.sonar.api.resources.File sonarFile = org.sonar.api.resources.File.fromIOFile((File)new File(squidFile.getKey()), (Project)this.project);
            this.saveMeasures(sonarFile, squidFile);
            this.saveFilesComplexityDistribution(sonarFile, squidFile);
            this.saveFunctionsComplexityDistribution(sonarFile, squidFile);
            this.saveViolations(sonarFile, squidFile);
        }
    }

    private void saveMeasures(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.FILES, Double.valueOf(squidFile.getDouble((MetricDef)CxxMetric.FILES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.LINES, Double.valueOf(squidFile.getDouble((MetricDef)CxxMetric.LINES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.NCLOC, Double.valueOf(squidFile.getDouble((MetricDef)CxxMetric.LINES_OF_CODE)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.STATEMENTS, Double.valueOf(squidFile.getDouble((MetricDef)CxxMetric.STATEMENTS)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.FUNCTIONS, Double.valueOf(squidFile.getDouble((MetricDef)CxxMetric.FUNCTIONS)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.CLASSES, Double.valueOf(squidFile.getDouble((MetricDef)CxxMetric.CLASSES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMPLEXITY, Double.valueOf(squidFile.getDouble((MetricDef)CxxMetric.COMPLEXITY)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMMENT_BLANK_LINES, Double.valueOf(squidFile.getDouble((MetricDef)CxxMetric.COMMENT_BLANK_LINES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMMENT_LINES, Double.valueOf(squidFile.getDouble((MetricDef)CxxMetric.COMMENT_LINES)));
    }

    private void saveFunctionsComplexityDistribution(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        Collection squidFunctionsInFile = this.scanner.getIndex().search(new Query[]{new QueryByParent((SourceCode)squidFile), new QueryByType(SourceFunction.class)});
        RangeDistributionBuilder complexityDistribution = new RangeDistributionBuilder(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, FUNCTIONS_DISTRIB_BOTTOM_LIMITS);
        for (SourceCode squidFunction : squidFunctionsInFile) {
            complexityDistribution.add((Number)squidFunction.getDouble((MetricDef)CxxMetric.COMPLEXITY));
        }
        this.context.saveMeasure((Resource)sonarFile, complexityDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
    }

    private void saveFilesComplexityDistribution(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        RangeDistributionBuilder complexityDistribution = new RangeDistributionBuilder(CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, FILES_DISTRIB_BOTTOM_LIMITS);
        complexityDistribution.add((Number)squidFile.getDouble((MetricDef)CxxMetric.COMPLEXITY));
        this.context.saveMeasure((Resource)sonarFile, complexityDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
    }

    private void saveViolations(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        Set messages = squidFile.getCheckMessages();
        if (messages != null) {
            for (CheckMessage message : messages) {
                Violation violation = Violation.create((ActiveRule)this.annotationCheckFactory.getActiveRule(message.getCheck()), (Resource)sonarFile).setLineId(message.getLine()).setMessage(message.getText(Locale.ENGLISH));
                this.context.saveViolation(violation);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

