/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.rats;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.RuleFinder;
import org.sonar.plugins.cxx.utils.CxxReportSensor;
import org.sonar.plugins.cxx.utils.CxxUtils;

public final class CxxRatsSensor
extends CxxReportSensor {
    private static final String MISSING_RATS_TYPE = "fixed size global buffer";
    public static final String REPORT_PATH_KEY = "sonar.cxx.rats.reportPath";
    private static final String DEFAULT_REPORT_PATH = "rats-reports/rats-result-*.xml";
    private RulesProfile profile;

    public CxxRatsSensor(RuleFinder ruleFinder, Settings conf, RulesProfile profile) {
        super(ruleFinder, conf);
        this.profile = profile;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return super.shouldExecuteOnProject(project) && !this.profile.getActiveRulesByRepository("rats").isEmpty();
    }

    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    protected String defaultReportPath() {
        return DEFAULT_REPORT_PATH;
    }

    protected void processReport(Project project, SensorContext context, File report) throws JDOMException, IOException {
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Element root = builder.build(report).getRootElement();
            List vulnerabilities = root.getChildren("vulnerability");
            for (Element vulnerability : vulnerabilities) {
                String type = this.getVulnerabilityType(vulnerability.getChild("type"));
                String message = vulnerability.getChild("message").getTextTrim();
                List files = vulnerability.getChildren("file");
                for (Element file : files) {
                    String fileName = file.getChild("name").getTextTrim();
                    List lines = file.getChildren("line");
                    for (Element lineElem : lines) {
                        String line = lineElem.getTextTrim();
                        this.saveViolation(project, context, "rats", fileName, line, type, message);
                    }
                }
            }
        }
        catch (JDOMParseException e) {
            CxxUtils.LOG.error("Ignore incomplete XML output from RATS '{}'", (Object)e.toString());
        }
    }

    private String getVulnerabilityType(Element child) {
        if (child != null) {
            return child.getTextTrim();
        }
        return MISSING_RATS_TYPE;
    }
}

