/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.pclint;

import com.ctc.wstx.exc.WstxEOFException;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.utils.StaxParser;
import org.sonar.plugins.cxx.utils.CxxReportSensor;
import org.sonar.plugins.cxx.utils.CxxUtils;
import org.sonar.plugins.cxx.utils.EmptyReportException;

public class CxxPCLintSensor
extends CxxReportSensor {
    public static final String REPORT_PATH_KEY = "sonar.cxx.pclint.reportPath";
    private static final String DEFAULT_REPORT_PATH = "pclint-reports/pclint-result-*.xml";
    private RulesProfile profile;

    public CxxPCLintSensor(RuleFinder ruleFinder, Settings conf, RulesProfile profile) {
        super(ruleFinder, conf);
        this.profile = profile;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return super.shouldExecuteOnProject(project) && !this.profile.getActiveRulesByRepository("pclint").isEmpty();
    }

    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    protected String defaultReportPath() {
        return DEFAULT_REPORT_PATH;
    }

    protected void processReport(final Project project, final SensorContext context, File report) throws XMLStreamException {
        StaxParser parser = new StaxParser(new StaxParser.XmlStreamHandler(){

            public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
                try {
                    rootCursor.advance();
                }
                catch (WstxEOFException eofExc) {
                    throw new EmptyReportException();
                }
                SMInputCursor errorCursor = rootCursor.childElementCursor("issue");
                while (errorCursor.getNext() != null) {
                    String msg;
                    String id;
                    String line;
                    String file = errorCursor.getAttrValue("file");
                    if (this.isInputValid(file, line = errorCursor.getAttrValue("line"), id = errorCursor.getAttrValue("number"), msg = errorCursor.getAttrValue("desc"))) {
                        if (msg.contains("MISRA 2004") || msg.contains("MISRA 2008")) {
                            id = this.mapMisraRulesToUniqueSonarRules(msg);
                        }
                        CxxPCLintSensor.this.saveViolation(project, context, "pclint", file, line, id, msg);
                        continue;
                    }
                    CxxUtils.LOG.warn("PCLint warning ignored: {}", (Object)msg);
                    String debugText = "File: " + file + ", Line: " + line + ", ID: " + id + ", msg: " + msg;
                    CxxUtils.LOG.debug(debugText);
                }
            }

            private boolean isInputValid(String file, String line, String id, String msg) {
                return !StringUtils.isEmpty((String)file) && !StringUtils.isEmpty((String)id) && !StringUtils.isEmpty((String)msg);
            }

            private String mapMisraRulesToUniqueSonarRules(String msg) {
                Pattern pattern = Pattern.compile("Rule\\x20(\\d{1,2}.\\d{1,2}|\\d{1,2}-\\d{1,2}-\\d{1,2}),");
                Matcher matcher = pattern.matcher(msg);
                matcher.find();
                String misraRule = matcher.group(1);
                String newKey = "M" + misraRule;
                String debugText = "Remap MISRA rule " + misraRule + " to key " + newKey;
                CxxUtils.LOG.debug(debugText);
                return newKey;
            }
        });
        parser.parse(report);
    }
}

