/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.cppcheck;

import com.ctc.wstx.exc.WstxEOFException;
import java.io.File;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.utils.StaxParser;
import org.sonar.plugins.cxx.utils.CxxReportSensor;
import org.sonar.plugins.cxx.utils.CxxUtils;
import org.sonar.plugins.cxx.utils.EmptyReportException;

public class CxxCppCheckSensor
extends CxxReportSensor {
    public static final String REPORT_PATH_KEY = "sonar.cxx.cppcheck.reportPath";
    private static final String DEFAULT_REPORT_PATH = "cppcheck-reports/cppcheck-result-*.xml";
    private RulesProfile profile;

    public CxxCppCheckSensor(RuleFinder ruleFinder, Settings conf, RulesProfile profile) {
        super(ruleFinder, conf);
        this.profile = profile;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return super.shouldExecuteOnProject(project) && !this.profile.getActiveRulesByRepository("cppcheck").isEmpty();
    }

    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    protected String defaultReportPath() {
        return DEFAULT_REPORT_PATH;
    }

    protected void processReport(final Project project, final SensorContext context, File report) throws XMLStreamException {
        StaxParser parser = new StaxParser(new StaxParser.XmlStreamHandler(){

            public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
                try {
                    rootCursor.advance();
                }
                catch (WstxEOFException eofExc) {
                    throw new EmptyReportException();
                }
                SMInputCursor errorCursor = rootCursor.childElementCursor("error");
                while (errorCursor.getNext() != null) {
                    String msg;
                    String id;
                    String line;
                    String file = errorCursor.getAttrValue("file");
                    if (this.isInputValid(file, line = errorCursor.getAttrValue("line"), id = errorCursor.getAttrValue("id"), msg = errorCursor.getAttrValue("msg"))) {
                        CxxCppCheckSensor.this.saveViolation(project, context, "cppcheck", file, line, id, msg);
                        continue;
                    }
                    CxxUtils.LOG.warn("Skipping invalid violation: '{}'", (Object)msg);
                }
            }

            private boolean isInputValid(String file, String line, String id, String msg) {
                return !StringUtils.isEmpty((String)file) && !StringUtils.isEmpty((String)id) && !StringUtils.isEmpty((String)msg);
            }
        });
        parser.parse(report);
    }
}

