/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.coverage;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.cxx.coverage.BullseyeParser;
import org.sonar.plugins.cxx.coverage.CoberturaParser;
import org.sonar.plugins.cxx.coverage.CoverageParser;
import org.sonar.plugins.cxx.utils.CxxReportSensor;
import org.sonar.plugins.cxx.utils.CxxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxxCoverageSensor
extends CxxReportSensor {
    private static final int UNIT_TEST_COVERAGE = 0;
    public static final int IT_TEST_COVERAGE = 1;
    public static final int OVERALL_TEST_COVERAGE = 2;
    public static final String REPORT_PATH_KEY = "sonar.cxx.coverage.reportPath";
    public static final String IT_REPORT_PATH_KEY = "sonar.cxx.coverage.itReportPath";
    public static final String OVERALL_REPORT_PATH_KEY = "sonar.cxx.coverage.overallReportPath";
    private static final String DEFAULT_REPORT_PATH = "coverage-reports/coverage-*.xml";
    private static final String IT_DEFAULT_REPORT_PATH = "coverage-reports/it-coverage-*.xml";
    private static final String OVERALL_DEFAULT_REPORT_PATH = "coverage-reports/overall-coverage-*.xml";
    private final Settings settings;
    private static List<CoverageParser> parsers = new LinkedList<CoverageParser>();

    public CxxCoverageSensor(Settings settings) {
        this.settings = settings;
        parsers.add(new CoberturaParser());
        parsers.add(new BullseyeParser());
    }

    @Override
    public void analyse(Project project, SensorContext context) {
        List<File> reports = this.getReports(this.settings, project.getFileSystem().getBasedir().getPath(), REPORT_PATH_KEY, DEFAULT_REPORT_PATH);
        CxxUtils.LOG.debug("Parsing coverage reports");
        Map<String, CoverageMeasuresBuilder> coverageMeasures = this.parseReports(reports);
        this.saveMeasures(project, context, coverageMeasures, 0);
        CxxUtils.LOG.debug("Parsing integration test coverage reports");
        List<File> itReports = this.getReports(this.settings, project.getFileSystem().getBasedir().getPath(), IT_REPORT_PATH_KEY, IT_DEFAULT_REPORT_PATH);
        Map<String, CoverageMeasuresBuilder> itCoverageMeasures = this.parseReports(itReports);
        this.saveMeasures(project, context, itCoverageMeasures, 1);
        CxxUtils.LOG.debug("Parsing overall test coverage reports");
        List<File> overallReports = this.getReports(this.settings, project.getFileSystem().getBasedir().getPath(), OVERALL_REPORT_PATH_KEY, OVERALL_DEFAULT_REPORT_PATH);
        Map<String, CoverageMeasuresBuilder> overallCoverageMeasures = this.parseReports(overallReports);
        this.saveMeasures(project, context, overallCoverageMeasures, 2);
    }

    private Map<String, CoverageMeasuresBuilder> parseReports(List<File> reports) {
        HashMap<String, CoverageMeasuresBuilder> measuresTotal = new HashMap<String, CoverageMeasuresBuilder>();
        HashMap<String, CoverageMeasuresBuilder> measuresForReport = new HashMap<String, CoverageMeasuresBuilder>();
        for (File report : reports) {
            boolean parsed = false;
            for (CoverageParser parser : parsers) {
                try {
                    measuresForReport.clear();
                    parser.parseReport(report, measuresForReport);
                    if (measuresForReport.isEmpty()) continue;
                    parsed = true;
                    measuresTotal.putAll(measuresForReport);
                    CxxUtils.LOG.info("Added report '{}' (parsed by: {}) to the coverage data", (Object)report, (Object)parser);
                    break;
                }
                catch (XMLStreamException e) {
                    CxxUtils.LOG.trace("Report {} cannot be parsed by {}", (Object)report, (Object)parser);
                }
            }
            if (parsed) continue;
            CxxUtils.LOG.error("Report {} cannot be parsed", (Object)report);
        }
        return measuresTotal;
    }

    private void saveMeasures(Project project, SensorContext context, Map<String, CoverageMeasuresBuilder> coverageMeasures, int coveragetype) {
        for (Map.Entry<String, CoverageMeasuresBuilder> entry : coverageMeasures.entrySet()) {
            String filePath = entry.getKey();
            org.sonar.api.resources.File cxxfile = org.sonar.api.resources.File.fromIOFile((File)new File(filePath), (Project)project);
            if (this.fileExist(context, cxxfile)) {
                CxxUtils.LOG.debug("Saving coverage measures for file '{}'", (Object)filePath);
                for (Measure measure : entry.getValue().createMeasures()) {
                    switch (coveragetype) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            measure = this.convertToItMeasure(measure);
                            break;
                        }
                        case 2: {
                            measure = this.convertForOverall(measure);
                            break;
                        }
                    }
                    context.saveMeasure((Resource)cxxfile, measure);
                }
                continue;
            }
            CxxUtils.LOG.warn("Cannot find the file '{}', ignoring coverage measures", (Object)filePath);
        }
    }

    Measure convertToItMeasure(Measure measure) {
        Measure itMeasure = null;
        Metric metric = measure.getMetric();
        Double value = measure.getValue();
        if (CoreMetrics.LINES_TO_COVER.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_LINES_TO_COVER, value);
        } else if (CoreMetrics.UNCOVERED_LINES.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_UNCOVERED_LINES, value);
        } else if (CoreMetrics.COVERAGE_LINE_HITS_DATA.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_COVERAGE_LINE_HITS_DATA, measure.getData());
        } else if (CoreMetrics.CONDITIONS_TO_COVER.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_CONDITIONS_TO_COVER, value);
        } else if (CoreMetrics.UNCOVERED_CONDITIONS.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_UNCOVERED_CONDITIONS, value);
        } else if (CoreMetrics.COVERED_CONDITIONS_BY_LINE.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_COVERED_CONDITIONS_BY_LINE, measure.getData());
        } else if (CoreMetrics.CONDITIONS_BY_LINE.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_CONDITIONS_BY_LINE, measure.getData());
        }
        return itMeasure;
    }

    private Measure convertForOverall(Measure measure) {
        Measure itMeasure = null;
        if (CoreMetrics.LINES_TO_COVER.equals((Object)measure.getMetric())) {
            itMeasure = new Measure(CoreMetrics.OVERALL_LINES_TO_COVER, measure.getValue());
        } else if (CoreMetrics.UNCOVERED_LINES.equals((Object)measure.getMetric())) {
            itMeasure = new Measure(CoreMetrics.OVERALL_UNCOVERED_LINES, measure.getValue());
        } else if (CoreMetrics.COVERAGE_LINE_HITS_DATA.equals((Object)measure.getMetric())) {
            itMeasure = new Measure(CoreMetrics.OVERALL_COVERAGE_LINE_HITS_DATA, measure.getData());
        } else if (CoreMetrics.CONDITIONS_TO_COVER.equals((Object)measure.getMetric())) {
            itMeasure = new Measure(CoreMetrics.OVERALL_CONDITIONS_TO_COVER, measure.getValue());
        } else if (CoreMetrics.UNCOVERED_CONDITIONS.equals((Object)measure.getMetric())) {
            itMeasure = new Measure(CoreMetrics.OVERALL_UNCOVERED_CONDITIONS, measure.getValue());
        } else if (CoreMetrics.COVERED_CONDITIONS_BY_LINE.equals((Object)measure.getMetric())) {
            itMeasure = new Measure(CoreMetrics.OVERALL_COVERED_CONDITIONS_BY_LINE, measure.getData());
        } else if (CoreMetrics.CONDITIONS_BY_LINE.equals((Object)measure.getMetric())) {
            itMeasure = new Measure(CoreMetrics.OVERALL_CONDITIONS_BY_LINE, measure.getData());
        }
        return itMeasure;
    }

    private boolean fileExist(SensorContext context, org.sonar.api.resources.File file) {
        return context.getResource((Resource)file) != null;
    }
}

