/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.RuleFinder;
import org.sonar.plugins.cxx.utils.CxxReportSensor;
import org.sonar.plugins.cxx.utils.CxxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxxCompilerSensor
extends CxxReportSensor {
    public static final String REPORT_PATH_KEY = "sonar.cxx.compiler.reportPath";
    private static final String DEFAULT_REPORT_PATH = "compiler-reports/BuildLog.htm";
    public static final String REPORT_REGEX_DEF = "sonar.cxx.compiler.regex";
    public static final String DEFAULT_REGEX_DEF = "^.*[\\\\,/](.*)\\(([0-9]+)\\)\\x20:\\x20warning\\x20(C\\d\\d\\d\\d):(.*)$";
    public static final String REPORT_CHARSET_DEF = "sonar.cxx.compiler.charset";
    public static final String DEFAULT_CHARSET_DEF = "UTF-16";
    private RulesProfile profile;

    public CxxCompilerSensor(RuleFinder ruleFinder, Settings conf, RulesProfile profile) {
        super(ruleFinder, conf);
        this.profile = profile;
    }

    @Override
    public boolean shouldExecuteOnProject(Project project) {
        return super.shouldExecuteOnProject(project) && !this.profile.getActiveRulesByRepository("compiler").isEmpty();
    }

    @Override
    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    @Override
    protected String defaultReportPath() {
        return DEFAULT_REPORT_PATH;
    }

    @Override
    protected void processReport(Project project, SensorContext context, File report) throws XMLStreamException {
        int countViolations = 0;
        String reportCharset = this.getStringProperty(REPORT_CHARSET_DEF, DEFAULT_CHARSET_DEF);
        String reportRegEx = this.getStringProperty(REPORT_REGEX_DEF, DEFAULT_REGEX_DEF);
        try {
            CxxUtils.LOG.debug("Scanner initialized with report '{}', CharSet= '" + reportCharset + "'", (Object)report);
            Scanner scanner = new Scanner(report, reportCharset);
            Pattern p = Pattern.compile(reportRegEx, 8);
            CxxUtils.LOG.debug("Using pattern : '" + p.toString() + "'");
            while (scanner.findWithinHorizon(p, 0) != null) {
                String filename = scanner.match().group(1);
                String line = scanner.match().group(2);
                String id = scanner.match().group(3);
                String msg = scanner.match().group(4);
                filename = CxxCompilerSensor.getCaseSensitiveFileName(filename, project.getFileSystem().getSourceDirs());
                CxxUtils.LOG.debug("Scanner-matches file='" + filename + "' line='" + line + "' id='" + id + "' msg=" + msg);
                if (this.isInputValid(filename, line, id, msg)) {
                    this.saveViolation(project, context, "compiler", filename, line, id, msg);
                    ++countViolations;
                    continue;
                }
                CxxUtils.LOG.warn("C-Compiler warning: {}", (Object)msg);
            }
            scanner.close();
            CxxUtils.LOG.info("C-Compiler warnings processed = " + countViolations);
        }
        catch (FileNotFoundException e) {
            CxxUtils.LOG.error("processReport Exception: report.getName - not processed '{}'", (Object)e.toString());
        }
        catch (IllegalArgumentException e1) {
            CxxUtils.LOG.error("processReport Exception: report.getName - not processed '{}'", (Object)e1.toString());
        }
    }

    private boolean isInputValid(String file, String line, String id, String msg) {
        return !StringUtils.isEmpty((String)file) && !StringUtils.isEmpty((String)line) && !StringUtils.isEmpty((String)id) && !StringUtils.isEmpty((String)msg);
    }

    private static String getCaseSensitiveFileName(String file, List<File> sourceDirs) {
        Iterator<File> iterator = sourceDirs.iterator();
        while (iterator.hasNext()) {
            File targetfile = new File(iterator.next().getPath() + "\\" + file);
            if (!targetfile.exists()) continue;
            try {
                return targetfile.getCanonicalFile().getName();
            }
            catch (IOException e) {
                CxxUtils.LOG.error("processReport GetRealFileName getName failed '{}'", (Object)e.toString());
            }
        }
        return file;
    }
}

