/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.AbstractLanguage;

public class CxxLanguage
extends AbstractLanguage {
    public static final String DEFAULT_SOURCE_SUFFIXES = ".cxx,.cpp,.cc,.c";
    public static final String DEFAULT_HEADER_SUFFIXES = ".hxx,.hpp,.hh,.h";
    public static final String KEY = "c++";
    private String[] sourceSuffixes;
    private String[] headerSuffixes;
    private String[] fileSuffixes;

    public CxxLanguage(Settings config) {
        super(KEY, KEY);
        this.sourceSuffixes = this.createStringArray(config.getStringArray("sonar.cxx.suffixes.sources"), DEFAULT_SOURCE_SUFFIXES);
        this.headerSuffixes = this.createStringArray(config.getStringArray("sonar.cxx.suffixes.headers"), DEFAULT_HEADER_SUFFIXES);
        this.fileSuffixes = this.mergeArrays(this.sourceSuffixes, this.headerSuffixes);
    }

    public CxxLanguage() {
        super(KEY, KEY);
        this.sourceSuffixes = this.createStringArray(null, DEFAULT_SOURCE_SUFFIXES);
        this.headerSuffixes = this.createStringArray(null, DEFAULT_HEADER_SUFFIXES);
        this.fileSuffixes = this.mergeArrays(this.sourceSuffixes, this.headerSuffixes);
    }

    public final String[] mergeArrays(String[] array1, String[] array2) {
        String[] result = new String[array1.length + array2.length];
        System.arraycopy(this.sourceSuffixes, 0, result, 0, array1.length);
        System.arraycopy(this.headerSuffixes, 0, result, array1.length, array2.length);
        return result;
    }

    public String[] getFileSuffixes() {
        return this.fileSuffixes;
    }

    public String[] getSourceFileSuffixes() {
        return this.sourceSuffixes;
    }

    public String[] getHeaderFileSuffixes() {
        return this.headerSuffixes;
    }

    private String[] createStringArray(String[] values, String defaultValues) {
        if (values == null || values.length == 0) {
            return StringUtils.split((String)defaultValues, (String)",");
        }
        return values;
    }
}

