package org.codehaus.plexus.logging.slf4j;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.codehaus.plexus.logging.BaseLoggerManager;
import org.codehaus.plexus.logging.Logger;

/**
 * Slf4jLoggerManager 
 *
 * @author <a href="mailto:joakim@erdfelt.com">Joakim Erdfelt</a>
 * @version $Id: Slf4jLoggerManager.java 8566 2009-12-12 18:46:23Z cstamas $
 */
public class Slf4jLoggerManager
    extends BaseLoggerManager
{
    protected Logger createLogger( String key )
    {
        // SLF4j is a facade for other loggers, setting treshold has no meaning
        return new Slf4jLogger( getThreshold(), org.slf4j.LoggerFactory.getLogger( key ) );
    }
}
