/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.maven.plugin.report;

import java.util.Iterator;
import java.util.List;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.maven.plugin.report.Configuration;
import org.codehaus.plexus.maven.plugin.report.Requirements;
import org.codehaus.plexus.util.StringUtils;
import org.jdom.Element;

public class Component
implements Comparable {
    private String description;
    private String role;
    private String roleHint;
    private String alias;
    private String version;
    private String implementation;
    private String instantiationStrategy;
    private Requirements requirements;
    private Configuration configuration;

    public Component(Element component) {
        Element element;
        this.description = component.getChildText("description");
        this.role = component.getChildText("role");
        this.roleHint = component.getChildText("role-hint");
        this.alias = component.getChildText("alias");
        this.version = component.getChildText("version");
        this.implementation = component.getChildText("implementation");
        this.instantiationStrategy = component.getChildTextTrim("instantiation-strategy");
        List list = component.getChildren("requirements");
        Iterator it = list.iterator();
        while (it.hasNext()) {
            element = (Element)it.next();
            this.requirements = new Requirements(element);
        }
        list = component.getChildren("configuration");
        it = list.iterator();
        while (it.hasNext()) {
            element = (Element)it.next();
            this.configuration = new Configuration(element);
        }
    }

    public String getRole() {
        return this.role;
    }

    public String getRoleHint() {
        return this.roleHint;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public boolean hasRoleHint() {
        return StringUtils.isNotEmpty((String)this.roleHint);
    }

    public void print(Sink sink, String javaDocDestDir, String jxrDestDir) {
        String title = !this.hasRoleHint() ? this.role : this.roleHint;
        sink.section3();
        sink.sectionTitle3();
        sink.text("Component: " + title);
        sink.sectionTitle3_();
        sink.section3_();
        sink.table();
        this.writeField(sink, "Role", this.role);
        this.writeField(sink, "Role hint", this.roleHint);
        sink.tableRow();
        sink.tableCell();
        sink.text("Implementation");
        sink.tableCell_();
        sink.tableCell();
        sink.monospaced();
        sink.text(this.implementation);
        sink.monospaced_();
        sink.text(" ");
        sink.link("../" + javaDocDestDir + "/" + this.implementation.replace('.', '/') + ".html");
        sink.text("javadoc");
        sink.link_();
        sink.link("../" + jxrDestDir + "/" + this.implementation.replace('.', '/') + ".html");
        sink.text(" ");
        sink.text("xref");
        sink.link_();
        sink.tableCell_();
        sink.tableRow_();
        this.writeField(sink, "Description", this.description);
        this.writeField(sink, "Alias", this.alias);
        this.writeField(sink, "Version", this.version);
        this.writeField(sink, "Instantiation strategy", this.instantiationStrategy);
        sink.table_();
        if (this.requirements != null) {
            this.requirements.print(sink);
        }
        if (this.configuration != null) {
            this.configuration.print(sink);
        }
    }

    private void writeField(Sink sink, String name, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            sink.tableRow();
            sink.tableCell();
            sink.text(name);
            sink.tableCell_();
            sink.tableCell();
            sink.monospaced();
            sink.text(value);
            sink.monospaced_();
            sink.tableCell_();
            sink.tableRow_();
        }
    }

    public int compareTo(Object o) {
        return ((Component)o).getId().compareTo(this.getId());
    }

    private String getId() {
        if (!this.hasRoleHint()) {
            return this.role;
        }
        return this.role + ":" + this.roleHint;
    }
}

