/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.IOException;
import java.lang.module.FindException;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CmdModuleNameExtractor {
    public static void main(String[] args) {
        Properties properties = new Properties();
        for (String path : args) {
            try {
                String moduleName = CmdModuleNameExtractor.getModuleName(Paths.get(path, new String[0]));
                if (moduleName == null) continue;
                properties.setProperty(path, moduleName);
            }
            catch (Exception e) {
                System.err.append(e.getMessage());
            }
        }
        try {
            properties.store(System.out, "");
        }
        catch (IOException e) {
            System.exit(1);
        }
    }

    public static String getModuleName(Path modulePath) throws FindException {
        Set<ModuleReference> moduleReferences = ModuleFinder.of(modulePath).findAll();
        Optional modRef = moduleReferences.stream().findFirst();
        return modRef.isPresent() ? ((ModuleReference)modRef.get()).descriptor().name() : null;
    }
}

