/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.util.DirectoryScanner;

public class PlexusIoFileResourceCollection
extends AbstractPlexusIoResourceCollection {
    public static final String ROLE_HINT = "files";
    private File baseDir;
    private boolean isFollowingSymLinks = true;

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public boolean isFollowingSymLinks() {
        return this.isFollowingSymLinks;
    }

    public void setFollowingSymLinks(boolean pIsFollowingSymLinks) {
        this.isFollowingSymLinks = pIsFollowingSymLinks;
    }

    private void addResources(List list, String[] resources) throws IOException {
        String prefix = this.getPrefix();
        if (prefix != null && prefix.length() == 0) {
            prefix = null;
        }
        File dir = this.getBaseDir();
        for (int i = 0; i < resources.length; ++i) {
            String name = resources[i];
            String sourceDir = name.replace('\\', '/');
            PlexusIoFileResource resource = new PlexusIoFileResource(new File(dir, sourceDir), name);
            if (!this.isSelected(resource)) continue;
            if (prefix != null) {
                resource.setName(prefix + name);
            }
            list.add(resource);
        }
    }

    public Iterator getResources() throws IOException {
        String[] exc;
        DirectoryScanner ds = new DirectoryScanner();
        File dir = this.getBaseDir();
        ds.setBasedir(dir);
        String[] inc = this.getIncludes();
        if (inc != null && inc.length > 0) {
            ds.setIncludes(inc);
        }
        if ((exc = this.getExcludes()) != null && exc.length > 0) {
            ds.setExcludes(exc);
        }
        if (this.isUsingDefaultExcludes()) {
            ds.addDefaultExcludes();
        }
        ds.setCaseSensitive(this.isCaseSensitive());
        ds.setFollowSymlinks(this.isFollowingSymLinks());
        ds.scan();
        ArrayList result = new ArrayList();
        if (this.isIncludingEmptyDirectories()) {
            String[] dirs = ds.getIncludedDirectories();
            this.addResources(result, dirs);
        }
        String[] files = ds.getIncludedFiles();
        this.addResources(result, files);
        return result.iterator();
    }
}

